/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.support.LazyEntity;
import org.molgenis.metadata.manager.mapper.AttributeReferenceMapper;
import org.molgenis.metadata.manager.model.EditorAttributeIdentifier;
import org.molgenis.metadata.manager.model.EditorEntityTypeParent;
import org.springframework.stereotype.Component;

@Component
class EntityTypeParentMapper {
    private final AttributeReferenceMapper attributeReferenceMapper;
    private final EntityTypeMetadata entityTypeMetadata;
    private final DataService dataService;

    public EntityTypeParentMapper(AttributeReferenceMapper attributeReferenceMapper, EntityTypeMetadata entityTypeMetadata, DataService dataService) {
        this.attributeReferenceMapper = Objects.requireNonNull(attributeReferenceMapper);
        this.entityTypeMetadata = Objects.requireNonNull(entityTypeMetadata);
        this.dataService = Objects.requireNonNull(dataService);
    }

    EntityType toEntityTypeReference(EditorEntityTypeParent editorEntityTypeParent) {
        if (editorEntityTypeParent == null) {
            return null;
        }
        return new EntityType((Entity)new LazyEntity((EntityType)this.entityTypeMetadata, this.dataService, (Object)editorEntityTypeParent.getId()));
    }

    EditorEntityTypeParent toEditorEntityTypeParent(EntityType entityType) {
        if (entityType == null) {
            return null;
        }
        String id = entityType.getId();
        String label = entityType.getLabel();
        ImmutableList<EditorAttributeIdentifier> attributes = this.attributeReferenceMapper.toEditorAttributeIdentifiers(entityType.getOwnAllAttributes());
        EditorEntityTypeParent parent = this.toEditorEntityTypeParent(entityType.getExtends());
        return EditorEntityTypeParent.create(id, label, attributes, parent);
    }
}

