/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.util.AttributeUtils;
import org.molgenis.metadata.manager.mapper.AttributeMapper;
import org.molgenis.metadata.manager.mapper.AttributeReferenceMapper;
import org.molgenis.metadata.manager.mapper.EntityTypeParentMapper;
import org.molgenis.metadata.manager.mapper.PackageMapper;
import org.molgenis.metadata.manager.mapper.TagMapper;
import org.molgenis.metadata.manager.model.EditorAttribute;
import org.molgenis.metadata.manager.model.EditorAttributeIdentifier;
import org.molgenis.metadata.manager.model.EditorEntityType;
import org.molgenis.metadata.manager.model.EditorEntityTypeParent;
import org.molgenis.metadata.manager.model.EditorPackageIdentifier;
import org.molgenis.metadata.manager.model.EditorTagIdentifier;
import org.molgenis.util.i18n.LanguageService;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeMapper {
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeMapper attributeMapper;
    private final AttributeReferenceMapper attributeReferenceMapper;
    private final PackageMapper packageMapper;
    private final TagMapper tagMapper;
    private final EntityTypeParentMapper entityTypeParentMapper;

    EntityTypeMapper(EntityTypeFactory entityTypeFactory, AttributeMapper attributeMapper, AttributeReferenceMapper attributeReferenceMapper, PackageMapper packageMapper, TagMapper tagMapper, EntityTypeParentMapper entityTypeParentMapper) {
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attributeMapper = Objects.requireNonNull(attributeMapper);
        this.attributeReferenceMapper = Objects.requireNonNull(attributeReferenceMapper);
        this.packageMapper = Objects.requireNonNull(packageMapper);
        this.tagMapper = Objects.requireNonNull(tagMapper);
        this.entityTypeParentMapper = Objects.requireNonNull(entityTypeParentMapper);
    }

    public EditorEntityType toEditorEntityType(EntityType entityType, List<Attribute> referringAttributes) {
        String id = entityType.getId();
        String label = entityType.getLabel();
        ImmutableMap<String, String> i18nLabel = this.toI18nLabel(entityType);
        String description = entityType.getDescription();
        ImmutableMap<String, String> i18nDescription = this.toI18nDescription(entityType);
        boolean isAbstract = entityType.isAbstract();
        String backend = entityType.getBackend();
        EditorPackageIdentifier pack = this.packageMapper.toEditorPackage(entityType.getPackage());
        EditorEntityTypeParent entityTypeParent = this.entityTypeParentMapper.toEditorEntityTypeParent(entityType.getExtends());
        ImmutableList<EditorAttribute> attributes = this.attributeMapper.toEditorAttributes(entityType.getOwnAllAttributes());
        ImmutableList<EditorAttributeIdentifier> editorReferringAttributes = this.attributeReferenceMapper.toEditorAttributeIdentifiers(referringAttributes);
        ImmutableList<EditorTagIdentifier> tags = this.tagMapper.toEditorTags(entityType.getTags());
        EditorAttributeIdentifier idAttribute = this.attributeReferenceMapper.toEditorAttributeIdentifier(entityType.getIdAttribute());
        EditorAttributeIdentifier labelAttribute = this.attributeReferenceMapper.toEditorAttributeIdentifier(entityType.getLabelAttribute());
        ImmutableList<EditorAttributeIdentifier> lookupAttributes = this.attributeReferenceMapper.toEditorAttributeIdentifiers(entityType.getLookupAttributes());
        return EditorEntityType.create(id, label, i18nLabel, description, i18nDescription, isAbstract, backend, pack, entityTypeParent, attributes, editorReferringAttributes, tags, idAttribute, labelAttribute, lookupAttributes);
    }

    public EditorEntityType createEditorEntityType() {
        EntityType entityType = (EntityType)this.entityTypeFactory.create();
        return this.toEditorEntityType(entityType, (List<Attribute>)ImmutableList.of());
    }

    public EntityType toEntityType(EditorEntityType editorEntityType) {
        if (!editorEntityType.isAbstract() && editorEntityType.getIdAttribute() == null) {
            throw new MolgenisDataException("ID attribute for EntityType [" + editorEntityType.getLabel() + "] cannot be null");
        }
        EntityType entityType = (EntityType)this.entityTypeFactory.create();
        entityType.setId(editorEntityType.getId());
        entityType.setPackage(this.packageMapper.toPackageReference(editorEntityType.getPackage()));
        entityType.setLabel(editorEntityType.getLabel());
        if (editorEntityType.getLabelI18n() != null) {
            LanguageService.getLanguageCodes().forEach(languageCode -> entityType.setLabel(languageCode, editorEntityType.getLabelI18n().get(languageCode)));
        }
        entityType.setDescription(editorEntityType.getDescription());
        if (editorEntityType.getDescriptionI18n() != null) {
            LanguageService.getLanguageCodes().forEach(languageCode -> entityType.setDescription(languageCode, editorEntityType.getDescriptionI18n().get(languageCode)));
        }
        entityType.setOwnAllAttributes(this.attributeMapper.toAttributes(editorEntityType.getAttributes(), editorEntityType));
        entityType.setAbstract(editorEntityType.isAbstract());
        entityType.setExtends(this.entityTypeParentMapper.toEntityTypeReference(editorEntityType.getEntityTypeParent()));
        entityType.setTags(this.tagMapper.toTagReferences(editorEntityType.getTags()));
        entityType.setBackend(editorEntityType.getBackend());
        return entityType;
    }

    private ImmutableMap<String, String> toI18nDescription(EntityType entityType) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        LanguageService.getLanguageCodes().forEach(languageCode -> {
            String description = entityType.getString(AttributeUtils.getI18nAttributeName((String)"description", (String)languageCode));
            if (description != null) {
                mapBuilder.put(languageCode, (Object)description);
            }
        });
        return mapBuilder.build();
    }

    private ImmutableMap<String, String> toI18nLabel(EntityType entityType) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        LanguageService.getLanguageCodes().forEach(languageCode -> {
            String label = entityType.getString(AttributeUtils.getI18nAttributeName((String)"label", (String)languageCode));
            if (label != null) {
                mapBuilder.put(languageCode, (Object)label);
            }
        });
        return mapBuilder.build();
    }
}

