/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import org.molgenis.data.Sort;
import org.molgenis.metadata.manager.model.EditorOrder;
import org.molgenis.metadata.manager.model.EditorSort;
import org.springframework.stereotype.Component;

@Component(value="metadataManagerSortMapper")
class SortMapper {
    SortMapper() {
    }

    Sort toSort(EditorSort editorSort) {
        if (editorSort == null) {
            return null;
        }
        List orders = editorSort.getOrders().stream().map(this::toOrder).collect(Collectors.toList());
        return new Sort(orders);
    }

    private Sort.Order toOrder(EditorOrder editorOrder) {
        if (editorOrder == null) {
            return null;
        }
        return new Sort.Order(editorOrder.getAttributeName(), this.toDirection(editorOrder.getDirection()));
    }

    private Sort.Direction toDirection(String editorDirection) {
        if (editorDirection == null) {
            return null;
        }
        return Sort.Direction.valueOf((String)editorDirection);
    }

    EditorSort toEditorSort(Sort sort) {
        if (sort == null) {
            return null;
        }
        return EditorSort.create(this.toEditorOrders((Iterable<Sort.Order>)sort));
    }

    private ImmutableList<EditorOrder> toEditorOrders(Iterable<Sort.Order> orders) {
        return ImmutableList.copyOf(Streams.stream(orders).map(this::toEditorOrder).iterator());
    }

    private EditorOrder toEditorOrder(Sort.Order order) {
        return EditorOrder.create(order.getAttr(), order.getDirection().toString());
    }
}

