/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.controller;

import java.util.List;
import java.util.Objects;
import org.molgenis.metadata.manager.model.EditorAttributeResponse;
import org.molgenis.metadata.manager.model.EditorEntityType;
import org.molgenis.metadata.manager.model.EditorEntityTypeResponse;
import org.molgenis.metadata.manager.model.EditorPackageIdentifier;
import org.molgenis.metadata.manager.service.MetadataManagerService;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/metadata-manager"})
public class MetadataManagerController
extends PluginController {
    public static final String METADATA_MANAGER = "metadata-manager";
    public static final String URI = "/plugin/metadata-manager";
    private static final String KEY_BASE_URL = "baseUrl";
    private MetadataManagerService metadataManagerService;
    private final MenuReaderService menuReaderService;

    public MetadataManagerController(MenuReaderService menuReaderService, MetadataManagerService metadataManagerService) {
        super(URI);
        this.metadataManagerService = Objects.requireNonNull(metadataManagerService);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
    }

    @GetMapping(value={"/**"})
    public String init(Model model) {
        model.addAttribute(KEY_BASE_URL, (Object)this.menuReaderService.findMenuItemPath(METADATA_MANAGER));
        return "view-metadata-manager";
    }

    @ResponseBody
    @GetMapping(value={"/editorPackages"}, produces={"application/json"})
    public List<EditorPackageIdentifier> getEditorPackages() {
        return this.metadataManagerService.getEditorPackages();
    }

    @ResponseBody
    @GetMapping(value={"/entityType/{id:.*}"}, produces={"application/json"})
    public EditorEntityTypeResponse getEditorEntityType(@PathVariable(value="id") String id) {
        return this.metadataManagerService.getEditorEntityType(id);
    }

    @ResponseBody
    @GetMapping(value={"/create/entityType"}, produces={"application/json"})
    public EditorEntityTypeResponse createEditorEntityType() {
        return this.metadataManagerService.createEditorEntityType();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/entityType"}, consumes={"application/json"})
    public void upsertEntityType(@RequestBody EditorEntityType editorEntityType) {
        this.metadataManagerService.upsertEntityType(editorEntityType);
    }

    @ResponseBody
    @GetMapping(value={"/create/attribute"}, produces={"application/json"})
    public EditorAttributeResponse createEditorAttribute() {
        return this.metadataManagerService.createEditorAttribute();
    }
}

