/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.data.meta.model.TagFactory;
import org.molgenis.data.support.LazyEntity;
import org.molgenis.metadata.manager.model.EditorTagIdentifier;
import org.springframework.stereotype.Component;

@Component
class TagMapper {
    private final TagFactory tagFactory;
    private final DataService dataService;

    TagMapper(TagFactory tagFactory, DataService dataService) {
        this.tagFactory = Objects.requireNonNull(tagFactory);
        this.dataService = Objects.requireNonNull(dataService);
    }

    Iterable<Tag> toTagReferences(List<EditorTagIdentifier> tags) {
        return tags.stream().map(this::toTagReference).collect(Collectors.toList());
    }

    private Tag toTagReference(EditorTagIdentifier editorTagIdentifier) {
        return new Tag((Entity)new LazyEntity((EntityType)this.tagFactory.getEntityType(), this.dataService, (Object)editorTagIdentifier.getId()));
    }

    ImmutableList<EditorTagIdentifier> toEditorTags(Iterable<Tag> tags) {
        return ImmutableList.copyOf(Streams.stream(tags).map(this::toEditorTag).iterator());
    }

    private EditorTagIdentifier toEditorTag(Tag tag) {
        return EditorTagIdentifier.create(tag.getId(), tag.getLabel());
    }
}

