/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metrics;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Metrics")
@RestController
@RequestMapping(value={"/api/metrics"})
public class MetricsController {
    public static final String ROLE_METRICS = "ROLE_METRICS";
    static final String BASE_URI = "/api/metrics";
    private final PrometheusMeterRegistry meterRegistry;

    MetricsController(PrometheusMeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @GetMapping(path={"prometheus"}, produces={"text/plain; version=0.0.4; charset=utf-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAnyRole('METRICS')")
    @ApiResponses(value={@ApiResponse(code=200, message="Tab separated metrics values in a format fit for prometheus to consume"), @ApiResponse(code=403, message="Current user does not have ROLE_METRICS"), @ApiResponse(code=401, message="User is not authenticated and anonymous user does not have ROLE_METRICS")})
    @ApiOperation(value="Get recorded metrics for prometheus.", response=String.class, produces="text/plain; version=0.0.4; charset=utf-8")
    public String prometheus() {
        return this.meterRegistry.scrape();
    }
}

