/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MeterBindersConfiguration {
    private MeterRegistry meterRegistry;

    public MeterBindersConfiguration(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry);
    }

    @Bean
    public ClassLoaderMetrics classLoaderMetrics() {
        return new ClassLoaderMetrics();
    }

    @Bean
    public JvmMemoryMetrics jvmMemoryMetrics() {
        return new JvmMemoryMetrics();
    }

    @Bean
    public JvmGcMetrics jvmGcMetrics() {
        return new JvmGcMetrics();
    }

    @Bean
    public ProcessorMetrics processorMetrics() {
        return new ProcessorMetrics();
    }

    @Bean
    public JvmThreadMetrics jvmThreadMetrics() {
        return new JvmThreadMetrics();
    }

    @Bean
    LogbackMetrics logbackMetrics() {
        return new LogbackMetrics();
    }

    @PostConstruct
    private void registerBeans() {
        this.classLoaderMetrics().bindTo(this.meterRegistry);
        this.jvmMemoryMetrics().bindTo(this.meterRegistry);
        this.jvmGcMetrics().bindTo(this.meterRegistry);
        this.processorMetrics().bindTo(this.meterRegistry);
        this.jvmThreadMetrics().bindTo(this.meterRegistry);
        this.logbackMetrics().bindTo(this.meterRegistry);
    }
}

