/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metrics;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
public class MolgenisTimedAspect {
    private final MeterRegistry registry;
    private final Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinpoint;

    MolgenisTimedAspect(MeterRegistry registry) {
        this(registry, pjp -> Tags.of((String[])new String[]{"class", pjp.getStaticPart().getSignature().getDeclaringTypeName(), "method", pjp.getStaticPart().getSignature().getName()}));
    }

    MolgenisTimedAspect(MeterRegistry registry, Function<ProceedingJoinPoint, Iterable<Tag>> tagsBasedOnJoinpoint) {
        this.registry = registry;
        this.tagsBasedOnJoinpoint = tagsBasedOnJoinpoint;
    }

    @Around(value="execution(* (@io.micrometer.core.annotation.Timed *).*(..))")
    public Object timedClassMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.timedProceed(pjp, method.getDeclaringClass().getAnnotation(Timed.class));
    }

    @Around(value="execution (@io.micrometer.core.annotation.Timed * *.*(..))")
    public Object timedMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.timedProceed(pjp, method.getAnnotation(Timed.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object timedProceed(ProceedingJoinPoint pjp, Timed timed) throws Throwable {
        Object object;
        if (timed.value().isEmpty()) {
            return pjp.proceed();
        }
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        try {
            object = pjp.proceed();
        }
        catch (Throwable throwable) {
            sample.stop(Timer.builder((String)timed.value()).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(this.tagsBasedOnJoinpoint.apply(pjp)).publishPercentileHistogram(Boolean.valueOf(timed.histogram())).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles()).register(this.registry));
            throw throwable;
        }
        sample.stop(Timer.builder((String)timed.value()).description(timed.description().isEmpty() ? null : timed.description()).tags(timed.extraTags()).tags(this.tagsBasedOnJoinpoint.apply(pjp)).publishPercentileHistogram(Boolean.valueOf(timed.histogram())).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles()).register(this.registry));
        return object;
    }
}

