/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.mutationdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.data.CrudRepository;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.mutationdb.MysqlViewService;
import org.molgenis.mutationdb.Row;
import org.molgenis.mutationdb.Value;
import org.molgenis.util.ResourceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/col7a1-mutations"})
public class MutationsViewController
extends MolgenisPluginController {
    public static final String ID = "col7a1-mutations";
    public static final String URI = "/plugin/col7a1-mutations";
    public static final String ENTITYNAME_MUTATIONSVIEW = "import_mutationsview";
    public static final String ENTITYNAME_MUTATIONS = "import_mutations";
    public static final String MUTATIONS__MUTATION_ID = "identifier_mutation";
    public static final String MUTATIONSVIEW__MUTATION_ID = "Subject Mutation ID";
    public static final String TITLE = "Mutations view";
    private final DataService dataService;
    private final MysqlViewService mysqlViewService;
    public static final List<String> HEADERS_NAMES = Arrays.asList("Mutation ID", "cDNA change", "Protein change", "Exon/Intron", "Consequence", "Inheritance", "Patient ID", "Phenotype");
    private static final String PATH_TO_INSERT_QUERY = "/mysql/mutationview_col7a1_prototype.sql";
    private static final String PATH_TO_NA_QUERY = "/mysql/mutationview_col7a1_prototype_update_na.sql";

    @Autowired
    public MutationsViewController(DataService dataService, MysqlViewService mysqlViewService) {
        super(URI);
        if (dataService == null) {
            throw new IllegalArgumentException("dataService is null");
        }
        this.dataService = dataService;
        if (mysqlViewService == null) {
            throw new IllegalArgumentException("mysqlViewService is null");
        }
        this.mysqlViewService = mysqlViewService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("title", (Object)TITLE);
        return "view-col7a1";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET}, produces={"application/json"})
    public String create(Model model) {
        List<Row> rows = null;
        if (this.dataService.hasRepository(ENTITYNAME_MUTATIONSVIEW) && this.dataService.hasRepository(ENTITYNAME_MUTATIONS)) {
            CrudRepository mutationsViewRepo = (CrudRepository)this.dataService.getRepositoryByEntityName(ENTITYNAME_MUTATIONSVIEW);
            CrudRepository mutationsRepo = (CrudRepository)this.dataService.getRepositoryByEntityName(ENTITYNAME_MUTATIONS);
            rows = this.createRows(mutationsViewRepo, mutationsRepo);
        }
        model.addAttribute("rows", rows);
        model.addAttribute("headers", HEADERS_NAMES);
        return "view-col7a1-table";
    }

    @RequestMapping(value={"/generate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean refresh(Model model) {
        if (this.dataService.hasRepository(ENTITYNAME_MUTATIONSVIEW)) {
            Repository mutationsViewRepo = this.dataService.getRepositoryByEntityName(ENTITYNAME_MUTATIONSVIEW);
            this.mysqlViewService.truncate(mutationsViewRepo.getEntityMetaData().getName());
            try {
                this.mysqlViewService.populateWithQuery(ResourceUtils.getString(((Object)((Object)this)).getClass(), (String)PATH_TO_INSERT_QUERY));
                this.mysqlViewService.populateWithQuery(ResourceUtils.getString(((Object)((Object)this)).getClass(), (String)PATH_TO_NA_QUERY));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private List<Row> createRows(CrudRepository mutationsViewRepo, CrudRepository mutationsRepo) {
        Iterator iterator = mutationsRepo.iterator();
        ArrayList<Row> rows = new ArrayList<Row>();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            String mutationId = entity.getString(MUTATIONS__MUTATION_ID);
            if (null == mutationId) continue;
            Iterable iterable = mutationsViewRepo.findAll(new QueryImpl().eq(MUTATIONSVIEW__MUTATION_ID, (Object)mutationId));
            Map<String, List<Value>> valuesPerHeader = this.mysqlViewService.valuesPerHeader(HEADERS_NAMES, iterable);
            Row row = this.mysqlViewService.createRow(HEADERS_NAMES, valuesPerHeader);
            rows.add(row);
        }
        return rows;
    }
}

