/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.mutationdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.mutationdb.Cell;
import org.molgenis.mutationdb.Row;
import org.molgenis.mutationdb.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MysqlViewService {
    private static final Logger logger = Logger.getLogger(MysqlViewService.class);
    @Autowired
    private DataService dataService;
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public MysqlViewService(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public Map<String, List<Value>> valuesPerHeader(List<String> headers, Iterable<Entity> iterable) {
        Iterator<Entity> iterator = iterable.iterator();
        HashMap<String, List<Value>> valuesMap = new HashMap<String, List<Value>>();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            for (String header : headers) {
                if (!valuesMap.containsKey(header)) {
                    valuesMap.put(header, new ArrayList());
                }
                if (entity.get(header) != null) {
                    ((List)valuesMap.get(header)).add(new Value(entity.get(header).toString()));
                    continue;
                }
                ((List)valuesMap.get(header)).add(new Value(""));
            }
        }
        return valuesMap;
    }

    public Row createRowByMergingValuesIfEquales(List<String> headers, Map<String, List<Value>> valuesByHeader) {
        Row row = new Row();
        for (String header : headers) {
            List<Value> values = valuesByHeader.get(header);
            if (null == values) continue;
            Cell cell = new Cell();
            if (values.isEmpty()) {
                row.add(cell);
                continue;
            }
            boolean equals = this.areAllValuesEquals(values);
            if (equals) {
                cell.add(values.get(0));
            } else {
                cell.addAll(values);
            }
            row.add(cell);
        }
        return row;
    }

    public Row createRow(List<String> headers, Map<String, List<Value>> valuesByHeader) {
        Row row = new Row();
        for (String header : headers) {
            List<Value> values = valuesByHeader.get(header);
            if (null == values) continue;
            Cell cell = new Cell();
            cell.addAll(values);
            row.add(cell);
        }
        return row;
    }

    public Row createRow(List<String> headers, Entity entity) {
        Row row = new Row();
        for (String header : headers) {
            Value value = null != entity.get(header) ? new Value(entity.get(header).toString()) : new Value("");
            Cell cell = new Cell();
            cell.add(value);
            row.add(cell);
        }
        return row;
    }

    public boolean areAllValuesEquals(List<Value> values) {
        if (values.isEmpty()) {
            return false;
        }
        Value lastValue = null;
        for (Value value : values) {
            if (lastValue == null) {
                lastValue = value;
            }
            if (lastValue.equals(value)) continue;
            return false;
        }
        return true;
    }

    public void truncate(String tableName) {
        this.jdbcTemplate.execute(this.getTruncateSql(tableName));
    }

    protected String getTruncateSql(String tableName) {
        return "TRUNCATE TABLE " + tableName + ";";
    }

    public void populateWithQuery(String insertQuery) {
        try {
            this.jdbcTemplate.execute(insertQuery);
        }
        catch (Exception e) {
            logger.error((Object)("Exception executing query: [" + insertQuery + "]"), (Throwable)e);
            throw new MolgenisDataException((Throwable)e);
        }
    }
}

