/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.mutationdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.data.CrudRepository;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.mutationdb.MysqlViewService;
import org.molgenis.mutationdb.Row;
import org.molgenis.mutationdb.Value;
import org.molgenis.util.ResourceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/col7a1-patients"})
public class PatientsViewController
extends MolgenisPluginController {
    public static final String ID = "col7a1-patients";
    public static final String URI = "/plugin/col7a1-patients";
    public static final List<String> HEADERS_NAMES = Arrays.asList("Patient ID", "Phenotype", "Mutation", "cDNA change", "Protein change", "Exon", "Consequence", "Reference");
    public static final String PATH_TO_INSERT_QUERY = "/mysql/patientview_col7a1_prototype.sql";
    public static final String ENTITYNAME_PATIENTS = "import_patients";
    public static final String ENTITYNAME_PATIENTSVIEW = "import_patientsview";
    public static final String PATIENT_ID = "Patient ID";
    public static final String TITLE = "Patients view";
    public final DataService dataService;
    private final MysqlViewService mysqlViewService;

    @Autowired
    public PatientsViewController(DataService dataService, MysqlViewService mysqlViewService) {
        super(URI);
        if (dataService == null) {
            throw new IllegalArgumentException("dataService is null");
        }
        this.dataService = dataService;
        if (mysqlViewService == null) {
            throw new IllegalArgumentException("mysqlViewService is null");
        }
        this.mysqlViewService = mysqlViewService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("title", (Object)TITLE);
        return "view-col7a1";
    }

    @RequestMapping(value={"/generate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean refresh() {
        if (this.dataService.hasRepository(ENTITYNAME_PATIENTSVIEW)) {
            CrudRepository patientsViewRepo = (CrudRepository)this.dataService.getRepositoryByEntityName(ENTITYNAME_PATIENTSVIEW);
            this.mysqlViewService.truncate(patientsViewRepo.getEntityMetaData().getName());
            patientsViewRepo.deleteAll();
            try {
                this.mysqlViewService.populateWithQuery(ResourceUtils.getString(((Object)((Object)this)).getClass(), (String)PATH_TO_INSERT_QUERY));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET}, produces={"application/json"})
    public String create(Model model) {
        List<Row> rows = null;
        if (this.dataService.hasRepository(ENTITYNAME_PATIENTS) && this.dataService.hasRepository(ENTITYNAME_PATIENTSVIEW)) {
            CrudRepository patientsViewRepo = (CrudRepository)this.dataService.getRepositoryByEntityName(ENTITYNAME_PATIENTSVIEW);
            CrudRepository patientsRepo = (CrudRepository)this.dataService.getRepositoryByEntityName(ENTITYNAME_PATIENTS);
            rows = this.createRows(patientsRepo, patientsViewRepo);
        }
        model.addAttribute("rows", rows);
        model.addAttribute("headers", HEADERS_NAMES);
        return "view-col7a1-table";
    }

    private List<Row> createRows(CrudRepository patientsRepo, CrudRepository patientsViewRepo) {
        Iterator iterator = patientsRepo.iterator();
        ArrayList<Row> rows = new ArrayList<Row>();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            String patientId = entity.getString(PATIENT_ID);
            if (null == patientId) continue;
            Iterable iterable = patientsViewRepo.findAll(new QueryImpl().eq(PATIENT_ID, (Object)patientId));
            Map<String, List<Value>> valuesPerHeader = this.mysqlViewService.valuesPerHeader(HEADERS_NAMES, iterable);
            rows.add(this.mysqlViewService.createRowByMergingValuesIfEquales(HEADERS_NAMES, valuesPerHeader));
        }
        return rows;
    }
}

