/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import java.util.Objects;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.ui.menu.MenuReaderService;
import org.molgenis.web.PluginController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/plugin/navigator"})
public class NavigatorController
extends PluginController {
    public static final String NAVIGATOR = "navigator";
    public static final String URI = "/plugin/navigator";
    private MenuReaderService menuReaderService;
    private LanguageService languageService;
    private AppSettings appSettings;

    public NavigatorController(MenuReaderService menuReaderService, LanguageService languageService, AppSettings appSettings) {
        super(URI);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.languageService = Objects.requireNonNull(languageService);
        this.appSettings = Objects.requireNonNull(appSettings);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("baseUrl", (Object)this.getBaseUrl());
        model.addAttribute("lng", (Object)this.languageService.getCurrentUserLanguageCode());
        model.addAttribute("fallbackLng", (Object)this.appSettings.getLanguageCode());
        return "view-navigator";
    }

    private String getBaseUrl() {
        return this.menuReaderService.getMenu().findMenuItemPath(NAVIGATOR);
    }
}

