/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import java.util.Objects;
import javax.validation.Valid;
import org.molgenis.core.ui.controller.VuePluginController;
import org.molgenis.core.ui.menu.MenuReaderService;
import org.molgenis.navigator.DeleteItemsRequest;
import org.molgenis.navigator.NavigatorService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.settings.AppSettings;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/navigator"})
public class NavigatorController
extends VuePluginController {
    public static final String ID = "navigator";
    public static final String URI = "/plugin/navigator";
    private final NavigatorService navigatorService;

    public NavigatorController(MenuReaderService menuReaderService, AppSettings appSettings, UserAccountService userAccountService, NavigatorService navigatorService) {
        super(URI, menuReaderService, appSettings, userAccountService);
        this.navigatorService = Objects.requireNonNull(navigatorService);
    }

    @GetMapping(value={"/**"})
    public String init(Model model) {
        super.init(model, ID);
        return "view-navigator";
    }

    @DeleteMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteItems(@RequestBody @Valid DeleteItemsRequest deleteItemsRequest) {
        this.navigatorService.deleteItems(deleteItemsRequest.getPackageIds(), deleteItemsRequest.getEntityTypeIds());
    }
}

