/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotEmpty;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.navigator.NavigatorService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NavigatorServiceImpl
implements NavigatorService {
    private final DataService dataService;

    NavigatorServiceImpl(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    @Override
    @Transactional
    public void deleteItems(List<String> packageIds, List<String> entityTypeIds) {
        if (packageIds.isEmpty() && entityTypeIds.isEmpty()) {
            return;
        }
        if (packageIds.isEmpty()) {
            this.deleteEntityTypes(entityTypeIds);
        } else {
            List<Package> deletablePackages = this.getDeletablePackages(packageIds);
            this.deleteEntityTypes(deletablePackages, entityTypeIds);
            this.deletePackages(deletablePackages);
        }
    }

    private void deleteEntityTypes(@NotEmpty List<String> entityTypeIds) {
        this.deleteEntityTypes(Collections.emptyList(), entityTypeIds);
    }

    private void deleteEntityTypes(List<Package> packages, List<String> entityTypeIds) {
        List<String> allEntityTypeIds;
        if (packages.isEmpty()) {
            allEntityTypeIds = entityTypeIds;
        } else {
            Stream<Object> allPackageEntityTypeIds = packages.stream().flatMap(aPackage -> Streams.stream((Iterable)aPackage.getEntityTypes())).map(EntityType::getId);
            allEntityTypeIds = entityTypeIds.isEmpty() ? allPackageEntityTypeIds.collect(Collectors.toList()) : Streams.concat((Stream[])new Stream[]{entityTypeIds.stream(), allPackageEntityTypeIds}).collect(Collectors.toList());
        }
        if (!allEntityTypeIds.isEmpty()) {
            this.dataService.deleteAll("sys_md_EntityType", allEntityTypeIds.stream());
        }
    }

    private void deletePackages(@NotEmpty List<Package> packages) {
        this.dataService.deleteAll("sys_md_Package", packages.stream().map(Package::getId));
    }

    private List<Package> getDeletablePackages(List<String> packageIds) {
        List<String> untypedPackageIds = packageIds;
        List packages = !packageIds.isEmpty() ? this.dataService.findAll("sys_md_Package", untypedPackageIds.stream(), Package.class).collect(Collectors.toList()) : Collections.emptyList();
        Iterable packageIterable = Traverser.forTree(Package::getChildren).breadthFirst(packages);
        return Lists.newArrayList((Iterable)packageIterable);
    }
}

