/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.service;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.molgenis.data.UnknownPackageException;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.util.PackageUtils;
import org.molgenis.i18n.ContextMessageSource;
import org.molgenis.i18n.ErrorCoded;
import org.molgenis.jobs.Progress;
import org.molgenis.navigator.copy.exception.UnknownCopyFailedException;
import org.molgenis.navigator.copy.service.CopyService;
import org.molgenis.navigator.copy.service.CopyState;
import org.molgenis.navigator.copy.service.EntityTypeCopier;
import org.molgenis.navigator.copy.service.PackageCopier;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.navigator.util.ResourceCollection;
import org.molgenis.navigator.util.ResourceCollector;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CopyServiceImpl
implements CopyService {
    private final ResourceCollector resourceCollector;
    private final MetaDataService metadataService;
    private final PackageCopier packageCopier;
    private final EntityTypeCopier entityTypeCopier;
    private final ContextMessageSource contextMessageSource;

    CopyServiceImpl(ResourceCollector resourceCollector, MetaDataService metadataService, PackageCopier packageCopier, EntityTypeCopier entityTypeCopier, ContextMessageSource contextMessageSource) {
        this.resourceCollector = Objects.requireNonNull(resourceCollector);
        this.metadataService = Objects.requireNonNull(metadataService);
        this.packageCopier = Objects.requireNonNull(packageCopier);
        this.entityTypeCopier = Objects.requireNonNull(entityTypeCopier);
        this.contextMessageSource = Objects.requireNonNull(contextMessageSource);
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public Void copy(List<ResourceIdentifier> resources, @Nullable String targetPackageId, Progress progress) {
        try {
            ResourceCollection resourceCollection = this.resourceCollector.get(resources);
            Package targetPackage = this.getPackage(targetPackageId);
            CopyState state = CopyState.create(targetPackage, progress);
            this.copyResources(resourceCollection, state);
        }
        catch (RuntimeException e) {
            if (e instanceof ErrorCoded) {
                throw e;
            }
            throw new UnknownCopyFailedException(e);
        }
        return null;
    }

    private void copyResources(ResourceCollection resourceCollection, CopyState state) {
        Progress progress = state.progress();
        progress.setProgressMax(this.calculateMaxProgress(resourceCollection));
        progress.progress(0, this.contextMessageSource.getMessage("progress-copy-started"));
        this.copyPackages(resourceCollection.getPackages(), state);
        this.copyEntityTypes(resourceCollection.getEntityTypes(), state);
        progress.status(this.contextMessageSource.getMessage("progress-copy-success"));
    }

    private void copyPackages(List<Package> packages, CopyState state) {
        if (!packages.isEmpty()) {
            state.progress().status(this.contextMessageSource.getMessage("progress-copy-packages"));
            this.packageCopier.copy(packages, state);
        }
    }

    private void copyEntityTypes(List<EntityType> entityTypes, CopyState state) {
        if (!entityTypes.isEmpty() || !state.entityTypesInPackages().isEmpty()) {
            state.progress().status(this.contextMessageSource.getMessage("progress-copy-entity-types"));
            this.entityTypeCopier.copy(entityTypes, state);
        }
    }

    private Package getPackage(@Nullable String targetPackageId) {
        return targetPackageId != null ? (Package)this.metadataService.getPackage(targetPackageId).orElseThrow(() -> new UnknownPackageException(targetPackageId)) : null;
    }

    private int calculateMaxProgress(ResourceCollection collection) {
        AtomicInteger maxProgress = new AtomicInteger();
        maxProgress.addAndGet(collection.getEntityTypes().size());
        maxProgress.addAndGet(collection.getPackages().size());
        collection.getPackages().forEach(packToCopy -> new PackageUtils.PackageTreeTraverser().postOrderTraversal(packToCopy).forEach(pack -> {
            maxProgress.addAndGet(Iterables.size((Iterable)pack.getChildren()));
            maxProgress.addAndGet(Iterables.size((Iterable)pack.getEntityTypes()));
        }));
        return maxProgress.get();
    }
}

