/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.service;

import com.google.common.collect.Streams;
import java.util.Map;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.util.EntityTypeUtils;
import org.springframework.stereotype.Service;

@Service
class RelationTransformer {
    private RelationTransformer() {
    }

    static void transformPackage(EntityType entityType, Map<String, Package> newPackages) {
        String packageId;
        if (newPackages.isEmpty()) {
            return;
        }
        if (entityType.getPackage() != null && newPackages.containsKey(packageId = entityType.getPackage().getId())) {
            entityType.setPackage(newPackages.get(packageId));
        }
    }

    static void transformExtends(EntityType entityType, Map<String, EntityType> newEntityTypes) {
        String extendsId;
        if (newEntityTypes.isEmpty()) {
            return;
        }
        if (entityType.getExtends() != null && newEntityTypes.containsKey(extendsId = entityType.getExtends().getId())) {
            entityType.setExtends(newEntityTypes.get(extendsId));
        }
    }

    static void transformRefEntities(EntityType entityType, Map<String, EntityType> newEntityTypes) {
        if (newEntityTypes.isEmpty()) {
            return;
        }
        Streams.stream((Iterable)entityType.getAtomicAttributes()).filter(EntityTypeUtils::isReferenceType).forEach(attr -> RelationTransformer.transformRefEntity(attr, newEntityTypes));
    }

    private static void transformRefEntity(Attribute attribute, Map<String, EntityType> newEntityTypes) {
        String refId;
        if (attribute.getRefEntity() != null && newEntityTypes.containsKey(refId = attribute.getRefEntity().getId())) {
            attribute.setRefEntity(newEntityTypes.get(refId));
        }
    }

    static void transformMappedBys(EntityType entityType, Map<String, Attribute> newAttributes) {
        if (newAttributes.isEmpty()) {
            return;
        }
        Streams.stream((Iterable)entityType.getAtomicAttributes()).filter(Attribute::isMappedBy).forEach(attr -> RelationTransformer.transformMappedBy(attr, newAttributes));
    }

    private static void transformMappedBy(Attribute attribute, Map<String, Attribute> newAttributes) {
        String mappedByAttrId;
        if (attribute.isMappedBy() && newAttributes.containsKey(mappedByAttrId = attribute.getMappedBy().getIdentifier())) {
            attribute.setMappedBy(newAttributes.get(mappedByAttrId));
        }
    }
}

