/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.model;

import javax.annotation.Nullable;
import org.molgenis.navigator.model.AutoValue_Resource;
import org.molgenis.navigator.model.ResourceType;
import org.molgenis.util.AutoGson;

@AutoGson(autoValueClass=AutoValue_Resource.class)
public abstract class Resource {
    public abstract ResourceType getType();

    public abstract String getId();

    public abstract String getLabel();

    @Nullable
    public abstract String getDescription();

    public abstract boolean isHidden();

    public abstract boolean isReadonly();

    public static Resource create(ResourceType newType, String newId, String newLabel, String newDescription, boolean newHidden, boolean newReadonly) {
        return Resource.builder().setType(newType).setId(newId).setLabel(newLabel).setDescription(newDescription).setHidden(newHidden).setReadonly(newReadonly).build();
    }

    public static Builder builder() {
        return new AutoValue_Resource.Builder().setHidden(false).setReadonly(false);
    }

    public static abstract class Builder {
        public abstract Builder setType(ResourceType var1);

        public abstract Builder setId(String var1);

        public abstract Builder setLabel(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setHidden(boolean var1);

        public abstract Builder setReadonly(boolean var1);

        public abstract Resource build();
    }
}

