
package org.molgenis.navigator.model;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Resource extends Resource {

  private final ResourceType type;
  private final String id;
  private final String label;
  private final String description;
  private final boolean hidden;
  private final boolean readonly;

  private AutoValue_Resource(
      ResourceType type,
      String id,
      String label,
      @Nullable String description,
      boolean hidden,
      boolean readonly) {
    this.type = type;
    this.id = id;
    this.label = label;
    this.description = description;
    this.hidden = hidden;
    this.readonly = readonly;
  }

  @Override
  public ResourceType getType() {
    return type;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getLabel() {
    return label;
  }

  @Nullable
  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public boolean isHidden() {
    return hidden;
  }

  @Override
  public boolean isReadonly() {
    return readonly;
  }

  @Override
  public String toString() {
    return "Resource{"
        + "type=" + type + ", "
        + "id=" + id + ", "
        + "label=" + label + ", "
        + "description=" + description + ", "
        + "hidden=" + hidden + ", "
        + "readonly=" + readonly
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Resource) {
      Resource that = (Resource) o;
      return (this.type.equals(that.getType()))
           && (this.id.equals(that.getId()))
           && (this.label.equals(that.getLabel()))
           && ((this.description == null) ? (that.getDescription() == null) : this.description.equals(that.getDescription()))
           && (this.hidden == that.isHidden())
           && (this.readonly == that.isReadonly());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= this.id.hashCode();
    h *= 1000003;
    h ^= this.label.hashCode();
    h *= 1000003;
    h ^= (description == null) ? 0 : this.description.hashCode();
    h *= 1000003;
    h ^= this.hidden ? 1231 : 1237;
    h *= 1000003;
    h ^= this.readonly ? 1231 : 1237;
    return h;
  }

  static final class Builder extends Resource.Builder {
    private ResourceType type;
    private String id;
    private String label;
    private String description;
    private Boolean hidden;
    private Boolean readonly;
    Builder() {
    }
    @Override
    public Resource.Builder setType(ResourceType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public Resource.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Resource.Builder setLabel(String label) {
      if (label == null) {
        throw new NullPointerException("Null label");
      }
      this.label = label;
      return this;
    }
    @Override
    public Resource.Builder setDescription(@Nullable String description) {
      this.description = description;
      return this;
    }
    @Override
    public Resource.Builder setHidden(boolean hidden) {
      this.hidden = hidden;
      return this;
    }
    @Override
    public Resource.Builder setReadonly(boolean readonly) {
      this.readonly = readonly;
      return this;
    }
    @Override
    public Resource build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.id == null) {
        missing += " id";
      }
      if (this.label == null) {
        missing += " label";
      }
      if (this.hidden == null) {
        missing += " hidden";
      }
      if (this.readonly == null) {
        missing += " readonly";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Resource(
          this.type,
          this.id,
          this.label,
          this.description,
          this.hidden,
          this.readonly);
    }
  }

}
