/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.util.PackageUtils;
import org.molgenis.jobs.JobExecutor;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.navigator.Folder;
import org.molgenis.navigator.NavigatorService;
import org.molgenis.navigator.copy.job.ResourceCopyJobExecution;
import org.molgenis.navigator.copy.job.ResourceCopyJobExecutionFactory;
import org.molgenis.navigator.delete.job.ResourceDeleteJobExecution;
import org.molgenis.navigator.delete.job.ResourceDeleteJobExecutionFactory;
import org.molgenis.navigator.download.job.ResourceDownloadJobExecution;
import org.molgenis.navigator.download.job.ResourceDownloadJobExecutionFactory;
import org.molgenis.navigator.model.Resource;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.navigator.model.ResourceType;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NavigatorServiceImpl
implements NavigatorService {
    private static final String MESSAGE_EMPTY_RESOURCES = "resources can't be empty";
    private final DataService dataService;
    private final JobExecutor jobExecutor;
    private final ResourceDownloadJobExecutionFactory downloadJobExecutionFactory;
    private final ResourceCopyJobExecutionFactory copyJobExecutionFactory;
    private final ResourceDeleteJobExecutionFactory resourceDeleteJobExecutionFactory;

    NavigatorServiceImpl(DataService dataService, JobExecutor jobExecutor, ResourceDownloadJobExecutionFactory downloadJobExecutionFactory, ResourceCopyJobExecutionFactory copyJobExecutionFactory, ResourceDeleteJobExecutionFactory resourceDeleteJobExecutionFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.jobExecutor = Objects.requireNonNull(jobExecutor);
        this.downloadJobExecutionFactory = Objects.requireNonNull(downloadJobExecutionFactory);
        this.copyJobExecutionFactory = Objects.requireNonNull(copyJobExecutionFactory);
        this.resourceDeleteJobExecutionFactory = Objects.requireNonNull(resourceDeleteJobExecutionFactory);
    }

    @Override
    @Transactional(readOnly=true)
    @Nullable
    public Folder getFolder(@Nullable String folderId) {
        Package aPackage = this.getPackage(folderId);
        return this.toFolder(aPackage);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Resource> getResources(@Nullable String folderId) {
        try (Stream<Resource> packageResources = this.dataService.query("sys_md_Package", Package.class).eq("parent", (Object)folderId).findAll().map(this::toResource);){
            Stream<Resource> entityTypeResources = this.dataService.query("sys_md_EntityType", EntityType.class).eq("package", (Object)folderId).findAll().map(this::toResource);
            List<Resource> list = Streams.concat((Stream[])new Stream[]{packageResources, entityTypeResources}).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Resource> findResources(String query) {
        Stream<Resource> packageResources = this.dataService.query("sys_md_Package", Package.class).search("label", query).or().search("description", query).findAll().map(this::toResource);
        Stream<Resource> entityTypeResources = this.dataService.query("sys_md_EntityType", EntityType.class).search("label", query).or().search("description", query).findAll().map(this::toResource);
        return Streams.concat((Stream[])new Stream[]{packageResources, entityTypeResources}).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void moveResources(List<ResourceIdentifier> resources, @Nullable String targetFolderId) {
        if (resources.isEmpty()) {
            return;
        }
        Package targetPackage = this.getPackage(targetFolderId);
        Map<ResourceType, List<ResourceIdentifier>> resourceMap = resources.stream().collect(Collectors.groupingBy(ResourceIdentifier::getType));
        resourceMap.forEach((type, typeResources) -> {
            switch (type) {
                case PACKAGE: {
                    this.movePackages((List<ResourceIdentifier>)typeResources, targetPackage);
                    break;
                }
                case ENTITY_TYPE: 
                case ENTITY_TYPE_ABSTRACT: {
                    this.moveEntityTypes((List<ResourceIdentifier>)typeResources, targetPackage);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)type);
                }
            }
        });
    }

    @Override
    public JobExecution copyResources(List<ResourceIdentifier> resources, @Nullable String targetFolderId) {
        if (resources.isEmpty()) {
            throw new IllegalArgumentException(MESSAGE_EMPTY_RESOURCES);
        }
        Package aPackage = this.getPackage(targetFolderId);
        ResourceCopyJobExecution jobExecution = (ResourceCopyJobExecution)this.copyJobExecutionFactory.create();
        jobExecution.setResources(resources);
        jobExecution.setTargetPackage(aPackage != null ? aPackage.getId() : null);
        this.jobExecutor.submit((JobExecution)jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecution downloadResources(List<ResourceIdentifier> resources) {
        if (resources.isEmpty()) {
            throw new IllegalArgumentException(MESSAGE_EMPTY_RESOURCES);
        }
        ResourceDownloadJobExecution jobExecution = (ResourceDownloadJobExecution)this.downloadJobExecutionFactory.create();
        jobExecution.setResources(resources);
        this.jobExecutor.submit((JobExecution)jobExecution);
        return jobExecution;
    }

    @Override
    @Transactional
    public JobExecution deleteResources(List<ResourceIdentifier> resources) {
        if (resources.isEmpty()) {
            throw new IllegalArgumentException(MESSAGE_EMPTY_RESOURCES);
        }
        ResourceDeleteJobExecution jobExecution = (ResourceDeleteJobExecution)this.resourceDeleteJobExecutionFactory.create();
        jobExecution.setResources(resources);
        this.jobExecutor.submit((JobExecution)jobExecution);
        return jobExecution;
    }

    @Override
    @Transactional
    public void updateResource(Resource resource) {
        ResourceType resourceType = resource.getType();
        switch (resourceType) {
            case PACKAGE: {
                this.updatePackage(resource);
                break;
            }
            case ENTITY_TYPE: 
            case ENTITY_TYPE_ABSTRACT: {
                this.updateEntityType(resource);
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)resourceType);
            }
        }
    }

    private void updatePackage(Resource resource) {
        Package aPackage = (Package)this.dataService.findOneById("sys_md_Package", (Object)resource.getId(), Package.class);
        if (aPackage == null) {
            throw new UnknownEntityException("sys_md_Package", (Object)resource.getId());
        }
        if (!com.google.common.base.Objects.equal((Object)aPackage.getLabel(), (Object)resource.getLabel()) || !com.google.common.base.Objects.equal((Object)aPackage.getDescription(), (Object)resource.getDescription())) {
            aPackage.setLabel(resource.getLabel());
            aPackage.setDescription(resource.getDescription());
            this.dataService.update("sys_md_Package", (Entity)aPackage);
        }
    }

    private void updateEntityType(Resource resource) {
        EntityType entityType = (EntityType)this.dataService.findOneById("sys_md_EntityType", (Object)resource.getId(), EntityType.class);
        if (entityType == null) {
            throw new UnknownEntityException("sys_md_EntityType", (Object)resource.getId());
        }
        if (!com.google.common.base.Objects.equal((Object)entityType.getLabel(), (Object)resource.getLabel()) || !com.google.common.base.Objects.equal((Object)entityType.getDescription(), (Object)resource.getDescription())) {
            entityType.setLabel(resource.getLabel());
            entityType.setDescription(resource.getDescription());
            this.dataService.update("sys_md_EntityType", (Entity)entityType);
        }
    }

    private void movePackages(List<ResourceIdentifier> typeResources, @Nullable Package targetPackage) {
        List<Package> packages = this.dataService.findAll("sys_md_Package", typeResources.stream().map(ResourceIdentifier::getId), Package.class).filter(aPackage -> this.isDifferentPackage(aPackage.getParent(), targetPackage)).collect(Collectors.toList());
        if (!packages.isEmpty()) {
            packages.forEach(aPackage -> aPackage.setParent(targetPackage));
            this.dataService.update("sys_md_Package", packages.stream());
        }
    }

    private void moveEntityTypes(List<ResourceIdentifier> typeResources, @Nullable Package targetPackage) {
        List<EntityType> entityTypes = this.dataService.findAll("sys_md_EntityType", typeResources.stream().map(ResourceIdentifier::getId), EntityType.class).filter(entityType -> this.isDifferentPackage(entityType.getPackage(), targetPackage)).collect(Collectors.toList());
        if (!entityTypes.isEmpty()) {
            entityTypes.forEach(entityType -> entityType.setPackage(targetPackage));
            this.dataService.update("sys_md_EntityType", entityTypes.stream());
        }
    }

    private boolean isDifferentPackage(@Nullable Package thisPackage, @Nullable Package thatPackage) {
        boolean isSame = thisPackage == null && thatPackage == null ? true : (thisPackage != null && thatPackage != null ? thisPackage.getId().equals(thatPackage.getId()) : false);
        return !isSame;
    }

    private Resource toResource(Package aPackage) {
        boolean isSystemPackage = PackageUtils.isSystemPackage((Package)aPackage);
        return Resource.builder().setType(ResourceType.PACKAGE).setId(aPackage.getId()).setLabel(aPackage.getLabel()).setDescription(aPackage.getDescription()).setHidden(isSystemPackage).setReadonly(isSystemPackage).build();
    }

    private Resource toResource(EntityType entityType) {
        ResourceType type = entityType.isAbstract() ? ResourceType.ENTITY_TYPE_ABSTRACT : ResourceType.ENTITY_TYPE;
        boolean isSystemEntityType = PackageUtils.isSystemPackage((Package)entityType.getPackage());
        return Resource.builder().setType(type).setId(entityType.getId()).setLabel(entityType.getLabel()).setDescription(entityType.getDescription()).setHidden(isSystemEntityType).setReadonly(isSystemEntityType).build();
    }

    @Nullable
    private Folder toFolder(@Nullable Package aPackage) {
        if (aPackage == null) {
            return null;
        }
        Folder parentFolder = aPackage.getParent() != null ? this.toFolder(aPackage.getParent()) : null;
        return Folder.create(aPackage.getId(), aPackage.getLabel(), parentFolder);
    }

    @Nullable
    private Package getPackage(@Nullable String folderId) {
        if (folderId == null) {
            return null;
        }
        Package aPackage = (Package)this.dataService.findOneById("sys_md_Package", (Object)folderId, Package.class);
        if (aPackage == null) {
            throw new UnknownEntityException("sys_md_Package", (Object)folderId);
        }
        return aPackage;
    }
}

