/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.job;

import java.util.List;
import java.util.Objects;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.molgenis.navigator.copy.job.ResourceCopyJobExecution;
import org.molgenis.navigator.copy.service.CopyService;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ResourceCopyJobConfig {
    private final CopyService copyService;

    public ResourceCopyJobConfig(CopyService copyService) {
        this.copyService = Objects.requireNonNull(copyService);
    }

    @Bean
    public JobFactory<ResourceCopyJobExecution> copyJobFactory() {
        return new JobFactory<ResourceCopyJobExecution>(){

            public Job<Void> createJob(ResourceCopyJobExecution jobExecution) {
                List<ResourceIdentifier> resources = jobExecution.getResources();
                String targetPackageId = jobExecution.getTargetPackage();
                return progress -> ResourceCopyJobConfig.this.copyService.copy(resources, targetPackageId, progress);
            }
        };
    }
}

