/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownPackageException;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.util.PackageUtils;
import org.molgenis.navigator.copy.exception.RecursiveCopyException;
import org.molgenis.navigator.copy.service.CopyState;
import org.molgenis.navigator.copy.service.LabelGenerator;
import org.springframework.stereotype.Component;

@Component
public class PackageCopier {
    private final DataService dataService;
    private final IdGenerator idGenerator;

    PackageCopier(DataService dataService, IdGenerator idGenerator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    public void copy(List<Package> packages, CopyState state) {
        packages.forEach(pack -> this.copyPackage((Package)pack, state));
    }

    private void copyPackage(Package pack, CopyState state) {
        this.validateNotContainsItself(pack, state.targetPackage());
        this.assignUniqueLabel(pack, state.targetPackage());
        this.copyPackageRecursive(pack, state.targetPackage(), state);
    }

    private void copyPackageRecursive(Package pack, Package parent, CopyState state) {
        state.entityTypesInPackages().addAll(Lists.newArrayList((Iterable)pack.getEntityTypes()));
        this.assignNewId(pack, state);
        pack.setParent(parent);
        this.dataService.add("sys_md_Package", (Entity)pack);
        state.progress().increment(1);
        pack.getChildren().forEach(child -> this.copyPackageRecursive(this.getPackage(child.getId()), pack, state));
    }

    private void assignNewId(Package pack, CopyState state) {
        String newId = this.idGenerator.generateId();
        state.copiedPackages().put(pack.getId(), pack);
        pack.setId(newId);
    }

    private void assignUniqueLabel(Package pack, Package targetPackage) {
        Set<String> existingLabels = targetPackage != null ? Streams.stream((Iterable)targetPackage.getChildren()).map(Package::getLabel).collect(Collectors.toSet()) : this.dataService.query("sys_md_Package", Package.class).eq("parent", null).findAll().map(Package::getLabel).collect(Collectors.toSet());
        pack.setLabel(LabelGenerator.generateUniqueLabel(pack.getLabel(), existingLabels));
    }

    private void validateNotContainsItself(Package pack, Package targetPackage) {
        if (PackageUtils.contains((Package)pack, (Package)targetPackage)) {
            throw new RecursiveCopyException();
        }
    }

    private Package getPackage(String id) {
        return (Package)this.dataService.getMeta().getPackage(id).orElseThrow(() -> new UnknownPackageException(id));
    }
}

