/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.delete.job;

import java.util.List;
import java.util.Objects;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.molgenis.navigator.delete.ResourceDeleteService;
import org.molgenis.navigator.delete.job.ResourceDeleteJobExecution;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.springframework.stereotype.Component;

@Component
class ResourceDeleteJobExecutionJobFactory
extends JobFactory<ResourceDeleteJobExecution> {
    private final ResourceDeleteService resourceDeleteService;

    ResourceDeleteJobExecutionJobFactory(ResourceDeleteService resourceDeleteService) {
        this.resourceDeleteService = Objects.requireNonNull(resourceDeleteService);
    }

    public Job<Void> createJob(ResourceDeleteJobExecution jobExecution) {
        List<ResourceIdentifier> resources = jobExecution.getResources();
        return progress -> this.resourceDeleteService.delete(resources, progress);
    }
}

