/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.download.job;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.molgenis.data.importer.emx.EmxFileExtensions;
import org.molgenis.i18n.MessageSourceHolder;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.molgenis.navigator.download.job.ResourceDownloadJobExecution;
import org.molgenis.navigator.download.job.ResourceDownloadService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.i18n.LocaleContextHolder;

@Configuration
public class ResourceDownloadConfig {
    private final ResourceDownloadService resourceDownloadService;

    public ResourceDownloadConfig(ResourceDownloadService resourceDownloadService) {
        this.resourceDownloadService = Objects.requireNonNull(resourceDownloadService);
    }

    @Bean
    public JobFactory<ResourceDownloadJobExecution> downloadJobExecutionJobFactory() {
        return new JobFactory<ResourceDownloadJobExecution>(){

            public Job createJob(ResourceDownloadJobExecution downloadJobExecution) {
                String fileType = EmxFileExtensions.XLSX.toString().toLowerCase();
                String filename = ResourceDownloadConfig.this.getDownloadFilename(fileType);
                downloadJobExecution.setResultUrl("/files/" + filename);
                downloadJobExecution.setProgressInt(0);
                downloadJobExecution.setProgressMessage(ResourceDownloadConfig.this.getMessage("progress-download-running", "Starting preparing download."));
                return progress -> ResourceDownloadConfig.this.resourceDownloadService.download(downloadJobExecution.getResources(), filename, progress);
            }
        };
    }

    private String getDownloadFilename(String extension) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss.SSS"));
        return String.format("%s.%s", timestamp, extension);
    }

    private String getMessage(String key, String defaultMessage) {
        return MessageSourceHolder.getMessageSource().getMessage(key, new Object[0], defaultMessage, LocaleContextHolder.getLocale());
    }
}

