
package org.molgenis.navigator;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.molgenis.navigator.model.Resource;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_GetResourcesResponse extends GetResourcesResponse {

  private final Folder folder;
  private final List<Resource> resources;

  private AutoValue_GetResourcesResponse(
      @Nullable Folder folder,
      List<Resource> resources) {
    this.folder = folder;
    this.resources = resources;
  }

  @Nullable
  @CheckForNull
  @Override
  public Folder getFolder() {
    return folder;
  }

  @Override
  public List<Resource> getResources() {
    return resources;
  }

  @Override
  public String toString() {
    return "GetResourcesResponse{"
        + "folder=" + folder + ", "
        + "resources=" + resources
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GetResourcesResponse) {
      GetResourcesResponse that = (GetResourcesResponse) o;
      return ((this.folder == null) ? (that.getFolder() == null) : this.folder.equals(that.getFolder()))
           && (this.resources.equals(that.getResources()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (folder == null) ? 0 : this.folder.hashCode();
    h *= 1000003;
    h ^= this.resources.hashCode();
    return h;
  }

  static final class Builder extends GetResourcesResponse.Builder {
    private Folder folder;
    private List<Resource> resources;
    Builder() {
    }
    @Override
    public GetResourcesResponse.Builder setFolder(@Nullable Folder folder) {
      this.folder = folder;
      return this;
    }
    @Override
    public GetResourcesResponse.Builder setResources(List<Resource> resources) {
      if (resources == null) {
        throw new NullPointerException("Null resources");
      }
      this.resources = resources;
      return this;
    }
    @Override
    public GetResourcesResponse build() {
      String missing = "";
      if (this.resources == null) {
        missing += " resources";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GetResourcesResponse(
          this.folder,
          this.resources);
    }
  }

}
