
package org.molgenis.navigator;

import java.util.List;
import javax.annotation.Generated;
import org.molgenis.navigator.model.ResourceIdentifier;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MoveResourcesRequest extends MoveResourcesRequest {

  private final List<ResourceIdentifier> resources;
  private final String targetFolderId;

  private AutoValue_MoveResourcesRequest(
      List<ResourceIdentifier> resources,
      String targetFolderId) {
    this.resources = resources;
    this.targetFolderId = targetFolderId;
  }

  @Override
  public List<ResourceIdentifier> getResources() {
    return resources;
  }

  @Override
  public String getTargetFolderId() {
    return targetFolderId;
  }

  @Override
  public String toString() {
    return "MoveResourcesRequest{"
        + "resources=" + resources + ", "
        + "targetFolderId=" + targetFolderId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MoveResourcesRequest) {
      MoveResourcesRequest that = (MoveResourcesRequest) o;
      return (this.resources.equals(that.getResources()))
           && (this.targetFolderId.equals(that.getTargetFolderId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.resources.hashCode();
    h *= 1000003;
    h ^= this.targetFolderId.hashCode();
    return h;
  }

  static final class Builder extends MoveResourcesRequest.Builder {
    private List<ResourceIdentifier> resources;
    private String targetFolderId;
    Builder() {
    }
    @Override
    public MoveResourcesRequest.Builder setResources(List<ResourceIdentifier> resources) {
      if (resources == null) {
        throw new NullPointerException("Null resources");
      }
      this.resources = resources;
      return this;
    }
    @Override
    public MoveResourcesRequest.Builder setTargetFolderId(String targetFolderId) {
      if (targetFolderId == null) {
        throw new NullPointerException("Null targetFolderId");
      }
      this.targetFolderId = targetFolderId;
      return this;
    }
    @Override
    public MoveResourcesRequest build() {
      String missing = "";
      if (this.resources == null) {
        missing += " resources";
      }
      if (this.targetFolderId == null) {
        missing += " targetFolderId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MoveResourcesRequest(
          this.resources,
          this.targetFolderId);
    }
  }

}
