/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import java.util.List;
import org.molgenis.navigator.CopyResourcesRequest;
import org.molgenis.navigator.model.ResourceIdentifier;

final class AutoValue_CopyResourcesRequest
extends CopyResourcesRequest {
    private final List<ResourceIdentifier> resources;
    private final String targetFolderId;

    private AutoValue_CopyResourcesRequest(List<ResourceIdentifier> resources, String targetFolderId) {
        this.resources = resources;
        this.targetFolderId = targetFolderId;
    }

    @Override
    public List<ResourceIdentifier> getResources() {
        return this.resources;
    }

    @Override
    public String getTargetFolderId() {
        return this.targetFolderId;
    }

    public String toString() {
        return "CopyResourcesRequest{resources=" + this.resources + ", targetFolderId=" + this.targetFolderId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CopyResourcesRequest) {
            CopyResourcesRequest that = (CopyResourcesRequest)o;
            return this.resources.equals(that.getResources()) && this.targetFolderId.equals(that.getTargetFolderId());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.resources.hashCode();
        h *= 1000003;
        return h ^= this.targetFolderId.hashCode();
    }

    static final class Builder
    extends CopyResourcesRequest.Builder {
        private List<ResourceIdentifier> resources;
        private String targetFolderId;

        Builder() {
        }

        @Override
        public CopyResourcesRequest.Builder setResources(List<ResourceIdentifier> resources) {
            if (resources == null) {
                throw new NullPointerException("Null resources");
            }
            this.resources = resources;
            return this;
        }

        @Override
        public CopyResourcesRequest.Builder setTargetFolderId(String targetFolderId) {
            if (targetFolderId == null) {
                throw new NullPointerException("Null targetFolderId");
            }
            this.targetFolderId = targetFolderId;
            return this;
        }

        @Override
        public CopyResourcesRequest build() {
            String missing = "";
            if (this.resources == null) {
                missing = missing + " resources";
            }
            if (this.targetFolderId == null) {
                missing = missing + " targetFolderId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CopyResourcesRequest(this.resources, this.targetFolderId);
        }
    }
}

