/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.download.job;

import com.google.gson.Gson;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.navigator.util.ResourceIdentifierUtil;

public class ResourceDownloadJobExecution
extends JobExecution {
    public ResourceDownloadJobExecution(Entity entity) {
        super(entity);
        this.setType("ResourceDownloadJob");
    }

    public ResourceDownloadJobExecution(EntityType entityType) {
        super(entityType);
        this.setType("ResourceDownloadJob");
    }

    public ResourceDownloadJobExecution(String identifier, EntityType entityType) {
        super(identifier, entityType);
        this.setType("ResourceDownloadJob");
    }

    public void setResources(List<ResourceIdentifier> resourceIdentifiers) {
        this.set("resources", new Gson().toJson(resourceIdentifiers));
    }

    @Nullable
    @CheckForNull
    public List<ResourceIdentifier> getResources() {
        String resourceJson = this.getString("resources");
        return ResourceIdentifierUtil.getResourcesFromJson(resourceJson);
    }
}

