/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.download.job;

import java.io.File;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.export.EmxExportService;
import org.molgenis.data.file.FileStore;
import org.molgenis.data.file.model.FileMeta;
import org.molgenis.data.file.model.FileMetaFactory;
import org.molgenis.i18n.MessageSourceHolder;
import org.molgenis.jobs.Progress;
import org.molgenis.navigator.download.exception.DownloadFailedException;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.navigator.util.ResourceCollection;
import org.molgenis.navigator.util.ResourceCollector;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ResourceDownloadService {
    private final EmxExportService emxExportService;
    private final FileStore fileStore;
    private final FileMetaFactory fileMetaFactory;
    private final DataService dataService;
    private final ResourceCollector resourceCollector;

    ResourceDownloadService(EmxExportService emxExportService, FileStore fileStore, FileMetaFactory fileMetaFactory, DataService dataService, ResourceCollector resourceCollector) {
        this.emxExportService = Objects.requireNonNull(emxExportService);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.fileMetaFactory = Objects.requireNonNull(fileMetaFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.resourceCollector = Objects.requireNonNull(resourceCollector);
    }

    public FileMeta download(List<ResourceIdentifier> resourceIdentifiers, String filename, Progress progress) {
        FileMeta fileMeta;
        try {
            ResourceCollection resourceCollection = this.resourceCollector.get(resourceIdentifiers);
            File emxFile = this.fileStore.getFileUnchecked(filename);
            fileMeta = this.createFileMeta(emxFile);
            this.dataService.add("sys_FileMeta", (Entity)fileMeta);
            this.emxExportService.export(resourceCollection.getEntityTypes(), resourceCollection.getPackages(), emxFile.toPath(), progress);
            progress.increment(1);
            progress.status(this.getMessage("progress-download-success", "Finished preparing download."));
        }
        catch (RuntimeException exception) {
            throw new DownloadFailedException(exception);
        }
        return fileMeta;
    }

    private String getMessage(String key, String defaultMessage) {
        return MessageSourceHolder.getMessageSource().getMessage(key, new Object[0], defaultMessage, LocaleContextHolder.getLocale());
    }

    private FileMeta createFileMeta(File file) {
        FileMeta fileMeta = (FileMeta)this.fileMetaFactory.create((Object)file.getName());
        fileMeta.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        fileMeta.setSize(Long.valueOf(file.length()));
        fileMeta.setFilename(file.getName());
        fileMeta.setUrl("/files/" + file.getName());
        return fileMeta;
    }
}

