/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.navigator.model.Resource;
import org.molgenis.navigator.model.ResourceType;

final class AutoValue_Resource
extends Resource {
    private final ResourceType type;
    private final String id;
    private final String label;
    private final String description;
    private final boolean hidden;
    private final boolean readonly;

    private AutoValue_Resource(ResourceType type, String id, String label, @Nullable String description, boolean hidden, boolean readonly) {
        this.type = type;
        this.id = id;
        this.label = label;
        this.description = description;
        this.hidden = hidden;
        this.readonly = readonly;
    }

    @Override
    public ResourceType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    public String toString() {
        return "Resource{type=" + (Object)((Object)this.type) + ", id=" + this.id + ", label=" + this.label + ", description=" + this.description + ", hidden=" + this.hidden + ", readonly=" + this.readonly + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Resource) {
            Resource that = (Resource)o;
            return this.type.equals((Object)that.getType()) && this.id.equals(that.getId()) && this.label.equals(that.getLabel()) && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription())) && this.hidden == that.isHidden() && this.readonly == that.isReadonly();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.id.hashCode();
        h *= 1000003;
        h ^= this.label.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.hidden ? 1231 : 1237;
        h *= 1000003;
        return h ^= this.readonly ? 1231 : 1237;
    }

    static final class Builder
    extends Resource.Builder {
        private ResourceType type;
        private String id;
        private String label;
        private String description;
        private Boolean hidden;
        private Boolean readonly;

        Builder() {
        }

        @Override
        public Resource.Builder setType(ResourceType type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public Resource.Builder setId(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public Resource.Builder setLabel(String label) {
            if (label == null) {
                throw new NullPointerException("Null label");
            }
            this.label = label;
            return this;
        }

        @Override
        public Resource.Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public Resource.Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Override
        public Resource.Builder setReadonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @Override
        public Resource build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.label == null) {
                missing = missing + " label";
            }
            if (this.hidden == null) {
                missing = missing + " hidden";
            }
            if (this.readonly == null) {
                missing = missing + " readonly";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Resource(this.type, this.id, this.label, this.description, this.hidden, this.readonly);
        }
    }
}

