/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.UnknownPackageException;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.navigator.util.ResourceCollection;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.stereotype.Component;

@Component
public class ResourceCollector {
    private final MetaDataService metaDataService;

    ResourceCollector(MetaDataService metaDataService) {
        this.metaDataService = Objects.requireNonNull(metaDataService);
    }

    private Package getPackage(String id) {
        return (Package)this.metaDataService.getPackage(id).orElseThrow(() -> new UnknownPackageException(id));
    }

    private EntityType getEntityType(String id) {
        return (EntityType)this.metaDataService.getEntityType(id).orElseThrow(() -> new UnknownEntityTypeException(id));
    }

    public ResourceCollection get(List<ResourceIdentifier> resources) {
        ArrayList<Package> packages = new ArrayList<Package>();
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        resources.forEach(resource -> {
            switch (resource.getType()) {
                case PACKAGE: {
                    packages.add(this.getPackage(resource.getId()));
                    break;
                }
                case ENTITY_TYPE: 
                case ENTITY_TYPE_ABSTRACT: {
                    entityTypes.add(this.getEntityType(resource.getId()));
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)resource.getType());
                }
            }
        });
        return ResourceCollection.of(packages, entityTypes);
    }
}

