/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.service;

import com.google.common.collect.Streams;
import java.util.Map;
import java.util.stream.Collectors;
import org.molgenis.data.AbstractEntityDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.file.model.FileMeta;
import org.molgenis.data.meta.model.EntityType;

class PretendingEntity
extends AbstractEntityDecorator {
    private final Map<String, EntityType> copiedEntityTypes;

    PretendingEntity(Entity entity, Map<String, EntityType> copiedEntityTypes) {
        super(entity);
        this.copiedEntityTypes = copiedEntityTypes;
    }

    public EntityType getEntityType() {
        String id = this.delegate().getEntityType().getId();
        if (this.copiedEntityTypes.containsKey(id)) {
            return this.copiedEntityTypes.get(id);
        }
        return this.delegate().getEntityType();
    }

    public Entity getEntity(String attributeName) {
        Entity entity = this.delegate().getEntity(attributeName);
        return entity != null ? this.newPretendingEntity(entity) : null;
    }

    public <E extends Entity> E getEntity(String attributeName, Class<E> clazz) {
        Entity entity = this.delegate().getEntity(attributeName, clazz);
        if (clazz.equals(FileMeta.class)) {
            return (E)(entity != null ? new FileMeta((Entity)this.newPretendingEntity(entity)) : null);
        }
        throw new UnsupportedOperationException("Can't return typed pretending entities");
    }

    public Iterable<Entity> getEntities(String attributeName) {
        return Streams.stream((Iterable)this.delegate().getEntities(attributeName)).map(this::newPretendingEntity).collect(Collectors.toList());
    }

    public <E extends Entity> Iterable<E> getEntities(String attributeName, Class<E> clazz) {
        Iterable entities = this.delegate().getEntities(attributeName, clazz);
        if (clazz.equals(FileMeta.class)) {
            return Streams.stream((Iterable)entities).map(this::newPretendingEntity).map(e -> new FileMeta((Entity)e)).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Can't return typed pretending entities");
    }

    private PretendingEntity newPretendingEntity(Entity entity) {
        return new PretendingEntity(entity, this.copiedEntityTypes);
    }
}

