package org.molgenis.navigator;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Folder extends Folder {

  private final String id;

  private final String label;

  private final Folder parent;

  private AutoValue_Folder(
      String id,
      String label,
      @Nullable Folder parent) {
    this.id = id;
    this.label = label;
    this.parent = parent;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getLabel() {
    return label;
  }

  @Nullable
  @CheckForNull
  @Override
  public Folder getParent() {
    return parent;
  }

  @Override
  public String toString() {
    return "Folder{"
         + "id=" + id + ", "
         + "label=" + label + ", "
         + "parent=" + parent
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Folder) {
      Folder that = (Folder) o;
      return this.id.equals(that.getId())
          && this.label.equals(that.getLabel())
          && (this.parent == null ? that.getParent() == null : this.parent.equals(that.getParent()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= label.hashCode();
    h$ *= 1000003;
    h$ ^= (parent == null) ? 0 : parent.hashCode();
    return h$;
  }

  static final class Builder extends Folder.Builder {
    private String id;
    private String label;
    private Folder parent;
    Builder() {
    }
    @Override
    public Folder.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Folder.Builder setLabel(String label) {
      if (label == null) {
        throw new NullPointerException("Null label");
      }
      this.label = label;
      return this;
    }
    @Override
    public Folder.Builder setParent(Folder parent) {
      this.parent = parent;
      return this;
    }
    @Override
    public Folder build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.label == null) {
        missing += " label";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Folder(
          this.id,
          this.label,
          this.parent);
    }
  }

}
