/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.delete;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.i18n.ContextMessageSource;
import org.molgenis.jobs.Progress;
import org.molgenis.navigator.delete.ResourceDeleteService;
import org.molgenis.navigator.model.ResourceIdentifier;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.stereotype.Service;

@Service
public class ResourceDeleteServiceImpl
implements ResourceDeleteService {
    private final DataService dataService;
    private final ContextMessageSource contextMessageSource;

    ResourceDeleteServiceImpl(DataService dataService, ContextMessageSource contextMessageSource) {
        this.dataService = Objects.requireNonNull(dataService);
        this.contextMessageSource = Objects.requireNonNull(contextMessageSource);
    }

    @Override
    public Void delete(List<ResourceIdentifier> resources, Progress progress) {
        progress.status(this.contextMessageSource.getMessage("progress-delete-started"));
        LinkedHashSet<Object> packageIds = new LinkedHashSet<Object>();
        LinkedHashSet<Object> entityTypeIds = new LinkedHashSet<Object>();
        resources.forEach(resource -> {
            switch (resource.getType()) {
                case PACKAGE: {
                    packageIds.add(resource.getId());
                    break;
                }
                case ENTITY_TYPE: 
                case ENTITY_TYPE_ABSTRACT: {
                    entityTypeIds.add(resource.getId());
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)resource.getType());
                }
            }
        });
        if (!entityTypeIds.isEmpty()) {
            this.deleteEntityTypes(entityTypeIds);
        }
        if (!packageIds.isEmpty()) {
            this.deletePackages(packageIds);
        }
        progress.status(this.contextMessageSource.getMessage("progress-delete-success"));
        return null;
    }

    private void deleteEntityTypes(@NotEmpty Set<Object> entityTypeIds) {
        List entityTypes = this.dataService.findAll("sys_md_EntityType", entityTypeIds.stream(), EntityType.class).collect(Collectors.toList());
        if (!entityTypes.isEmpty()) {
            this.dataService.delete("sys_md_EntityType", entityTypes.stream());
        }
    }

    private void deletePackages(Set<Object> packageIds) {
        List<Package> deletablePackages;
        List<Package> packages = this.dataService.findAll("sys_md_Package", packageIds.stream(), Package.class).collect(Collectors.toList());
        if (!packages.isEmpty() && !(deletablePackages = this.getDeletablePackages(packages, packageIds)).isEmpty()) {
            this.dataService.delete("sys_md_Package", deletablePackages.stream());
        }
    }

    private List<Package> getDeletablePackages(List<Package> packages, Set<Object> packageIds) {
        return packages.stream().filter(aPackage -> this.isDeletablePackage((Package)aPackage, packageIds)).collect(Collectors.toList());
    }

    private boolean isDeletablePackage(Package aPackage, Set<Object> packageIds) {
        for (Package parentPackage = aPackage.getParent(); parentPackage != null; parentPackage = parentPackage.getParent()) {
            if (!packageIds.contains(parentPackage.getId())) continue;
            return false;
        }
        return true;
    }
}

