/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator.copy.service;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.EntityTypeDependencyResolver;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.navigator.copy.service.CopyState;
import org.molgenis.navigator.copy.service.EntityTypeMetadataCopier;
import org.molgenis.navigator.copy.service.LabelGenerator;
import org.molgenis.navigator.copy.service.PretendingEntity;
import org.molgenis.navigator.copy.service.RelationTransformer;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeCopier {
    private static final int BATCH_SIZE = 1000;
    private final DataService dataService;
    private final IdGenerator idGenerator;
    private final EntityTypeDependencyResolver entityTypeDependencyResolver;
    private final EntityTypeMetadataCopier entityTypeMetadataCopier;

    EntityTypeCopier(DataService dataService, IdGenerator idGenerator, EntityTypeDependencyResolver entityTypeDependencyResolver, EntityTypeMetadataCopier entityTypeMetadataCopier) {
        this.dataService = Objects.requireNonNull(dataService);
        this.idGenerator = Objects.requireNonNull(idGenerator);
        this.entityTypeDependencyResolver = Objects.requireNonNull(entityTypeDependencyResolver);
        this.entityTypeMetadataCopier = Objects.requireNonNull(entityTypeMetadataCopier);
    }

    public void copy(List<EntityType> entityTypes, CopyState state) {
        List<EntityType> preparedEntityTypes = this.prepareEntityTypes(entityTypes, state);
        List<EntityType> copiedEntityTypes = this.copyEntityTypes(preparedEntityTypes, state);
        this.persist(copiedEntityTypes, state);
    }

    private List<EntityType> prepareEntityTypes(List<EntityType> entityTypes, CopyState state) {
        return this.removeDoubles(entityTypes, state).map(entityType -> this.assignUniqueLabel((EntityType)entityType, state)).map(entityType -> this.setTargetPackage((EntityType)entityType, state)).collect(Collectors.toList());
    }

    private Stream<EntityType> removeDoubles(List<EntityType> entityTypes, CopyState state) {
        Set idsInPackages = state.entityTypesInPackages().stream().map(EntityType::getId).collect(Collectors.toSet());
        return entityTypes.stream().filter(e -> !idsInPackages.contains(e.getId()));
    }

    private List<EntityType> copyEntityTypes(List<EntityType> entityTypes, CopyState state) {
        List<EntityType> copiedEntityTypes = Stream.concat(entityTypes.stream(), state.entityTypesInPackages().stream()).map(original -> this.copyEntityType((EntityType)original, state)).collect(Collectors.toList());
        copiedEntityTypes.forEach(entityType -> this.transformRelations((EntityType)entityType, state));
        return copiedEntityTypes;
    }

    private void persist(List<EntityType> copiedEntityTypes, CopyState state) {
        List persistedEntityTypes = this.entityTypeDependencyResolver.resolve(copiedEntityTypes).stream().map(copy -> this.cutDefaultValues((EntityType)copy, state)).map(this::persistEntityType).collect(Collectors.toList());
        persistedEntityTypes.stream().map(copy -> this.copyEntities((EntityType)copy, state)).map(copy -> this.pasteDefaultValues((EntityType)copy, state)).forEach(e -> state.progress().increment(1));
    }

    private EntityType setTargetPackage(EntityType entityType, CopyState state) {
        entityType.setPackage(state.targetPackage());
        return entityType;
    }

    private EntityType assignUniqueLabel(EntityType entityType, CopyState state) {
        Package targetPackage = state.targetPackage();
        Set<String> existingLabels = targetPackage != null ? Streams.stream((Iterable)targetPackage.getEntityTypes()).map(EntityType::getLabel).collect(Collectors.toSet()) : this.dataService.query("sys_md_EntityType", EntityType.class).eq("package", null).findAll().map(EntityType::getLabel).collect(Collectors.toSet());
        entityType.setLabel(LabelGenerator.generateUniqueLabel(entityType.getLabel(), existingLabels));
        return entityType;
    }

    private EntityType copyEntityType(EntityType original, CopyState state) {
        EntityType copy = this.entityTypeMetadataCopier.copy(original, state);
        String newId = this.idGenerator.generateId();
        copy.setId(newId);
        state.copiedEntityTypes().put(original.getId(), copy);
        state.originalEntityTypeIds().put(newId, original.getId());
        return copy;
    }

    private void transformRelations(EntityType entityType, CopyState state) {
        RelationTransformer.transformPackage(entityType, state.copiedPackages());
        RelationTransformer.transformExtends(entityType, state.copiedEntityTypes());
        RelationTransformer.transformRefEntities(entityType, state.copiedEntityTypes());
        RelationTransformer.transformMappedBys(entityType, state.copiedAttributes());
    }

    private EntityType cutDefaultValues(EntityType copy, CopyState state) {
        Streams.stream((Iterable)copy.getAtomicAttributes()).filter(EntityTypeUtils::isReferenceType).filter(Attribute::hasDefaultValue).forEach(attr -> {
            state.referenceDefaultValues().put(attr.getIdentifier(), attr.getDefaultValue());
            attr.setDefaultValue(null);
        });
        return copy;
    }

    private EntityType pasteDefaultValues(EntityType copy, CopyState state) {
        Streams.stream((Iterable)copy.getAtomicAttributes()).filter(EntityTypeUtils::isReferenceType).forEach(attr -> attr.setDefaultValue((String)state.referenceDefaultValues().getOrDefault(attr.getIdentifier(), null)));
        this.dataService.getMeta().updateEntityType(copy);
        return copy;
    }

    private EntityType persistEntityType(EntityType copy) {
        this.dataService.getMeta().addEntityType(copy);
        return copy;
    }

    private EntityType copyEntities(EntityType copy, CopyState state) {
        String originalEntityTypeId = state.originalEntityTypeIds().get(copy.getId());
        if (!copy.isAbstract()) {
            this.dataService.getRepository(originalEntityTypeId).forEachBatched(batch -> this.addEntityBatch(copy, state, (List<Entity>)batch), 1000);
        }
        return copy;
    }

    private void addEntityBatch(EntityType copy, CopyState state, List<Entity> batch) {
        this.dataService.add(copy.getId(), batch.stream().map(entity -> new PretendingEntity((Entity)entity, state.copiedEntityTypes())));
    }
}

