/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.navigator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.navigator.CopyResourcesRequest;
import org.molgenis.navigator.DeleteResourcesRequest;
import org.molgenis.navigator.DownloadResourcesRequest;
import org.molgenis.navigator.Folder;
import org.molgenis.navigator.GetResourcesResponse;
import org.molgenis.navigator.MoveResourcesRequest;
import org.molgenis.navigator.NavigatorService;
import org.molgenis.navigator.SearchResourcesResponse;
import org.molgenis.navigator.UpdateResourceRequest;
import org.molgenis.navigator.model.Resource;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/navigator"})
public class NavigatorController
extends PluginController {
    public static final String ID = "navigator";
    public static final String URI = "/plugin/navigator";
    private static final String KEY_BASE_URL = "baseUrl";
    private final NavigatorService navigatorService;
    private final MenuReaderService menuReaderService;

    NavigatorController(MenuReaderService menuReaderService, NavigatorService navigatorService) {
        super(URI);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.navigatorService = Objects.requireNonNull(navigatorService);
    }

    @GetMapping(value={"/**"})
    public String init(Model model) {
        model.addAttribute(KEY_BASE_URL, (Object)this.menuReaderService.findMenuItemPath(ID));
        Arrays.asList("dataexplorer", "metadata-manager", "importwizard").forEach(pluginId -> model.addAttribute(pluginId.replace('-', '_'), (Object)this.menuReaderService.findMenuItemPath(pluginId)));
        return "view-navigator";
    }

    @GetMapping(value={"/get"})
    @ResponseBody
    public GetResourcesResponse getResources(@RequestParam(value="folderId", required=false) @Nullable @CheckForNull String folderId) {
        Folder folder = this.navigatorService.getFolder(folderId);
        List<Resource> resources = this.navigatorService.getResources(folderId);
        return GetResourcesResponse.create(folder, resources);
    }

    @GetMapping(value={"/search"})
    @ResponseBody
    public SearchResourcesResponse searchResources(@RequestParam(value="query") String query) {
        List<Resource> resources = this.navigatorService.findResources(query);
        return SearchResourcesResponse.create(resources);
    }

    @PutMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateResource(@RequestBody @Valid UpdateResourceRequest updateResourceRequest) {
        this.navigatorService.updateResource(updateResourceRequest.getResource());
    }

    @PostMapping(value={"/copy"})
    @ResponseBody
    public JobExecution copyResources(@RequestBody @Valid CopyResourcesRequest copyResourcesRequest) {
        return this.navigatorService.copyResources(copyResourcesRequest.getResources(), copyResourcesRequest.getTargetFolderId());
    }

    @PostMapping(value={"/download"})
    @ResponseBody
    public JobExecution downloadResources(@RequestBody @Valid DownloadResourcesRequest downloadResourcesRequest) {
        return this.navigatorService.downloadResources(downloadResourcesRequest.getResources());
    }

    @PostMapping(value={"/move"})
    @ResponseStatus(value=HttpStatus.OK)
    public void moveResources(@RequestBody @Valid MoveResourcesRequest moveResourcesRequest) {
        this.navigatorService.moveResources(moveResourcesRequest.getResources(), moveResourcesRequest.getTargetFolderId());
    }

    @DeleteMapping(value={"/delete"})
    @ResponseBody
    public JobExecution deleteResources(@RequestBody @Valid DeleteResourcesRequest deleteItemsRequest) {
        return this.navigatorService.deleteResources(deleteItemsRequest.getResources());
    }
}

