package org.molgenis.navigator.model;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ResourceIdentifier extends ResourceIdentifier {

  private final ResourceType type;

  private final String id;

  private AutoValue_ResourceIdentifier(
      ResourceType type,
      String id) {
    this.type = type;
    this.id = id;
  }

  @Override
  public ResourceType getType() {
    return type;
  }

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String toString() {
    return "ResourceIdentifier{"
         + "type=" + type + ", "
         + "id=" + id
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ResourceIdentifier) {
      ResourceIdentifier that = (ResourceIdentifier) o;
      return this.type.equals(that.getType())
          && this.id.equals(that.getId());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    return h$;
  }

  static final class Builder extends ResourceIdentifier.Builder {
    private ResourceType type;
    private String id;
    Builder() {
    }
    @Override
    public ResourceIdentifier.Builder setType(ResourceType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ResourceIdentifier.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public ResourceIdentifier build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.id == null) {
        missing += " id";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ResourceIdentifier(
          this.type,
          this.id);
    }
  }

}
