/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.annotators.ui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import org.molgenis.annotators.ui.AnnotatorsUIService;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.AnnotationService;
import org.molgenis.data.annotation.RepositoryAnnotator;
import org.molgenis.data.omx.annotation.OmxDataSetAnnotator;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.search.DataSetsIndexer;
import org.molgenis.search.SearchService;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/annotateUI"})
public class AnnotatorsUIController
extends MolgenisPluginController {
    private static final Logger logger = Logger.getLogger(AnnotatorsUIController.class);
    private static final String ID = "annotateUI";
    public static final String URI = "/plugin/annotateUI";
    private final AnnotatorsUIService pluginAnnotatorsUIService;
    @Autowired
    DataService dataService;
    @Autowired
    FileStore fileStore;
    @Autowired
    SearchService searchService;
    @Autowired
    AnnotationService annotationService;
    @Autowired
    DataSetsIndexer indexer;
    @Autowired
    EntityValidator entityValidator;

    @Autowired
    public AnnotatorsUIController(AnnotatorsUIService pluginAnnotatorsUIService) {
        super(URI);
        if (pluginAnnotatorsUIService == null) {
            throw new IllegalArgumentException("pluginAnnotatorsUIService is null");
        }
        this.pluginAnnotatorsUIService = pluginAnnotatorsUIService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(String selectedDataSetIdentifier, Model model) {
        ArrayList dataSets = Lists.newArrayList((Iterable)this.dataService.findAll("DataSet", new QueryImpl().sort(new Sort(Sort.Direction.DESC, new String[]{"startTime"})), DataSet.class));
        model.addAttribute("dataSets", (Object)dataSets);
        DataSet selectedDataSet = null;
        if (dataSets != null && !dataSets.isEmpty()) {
            if (selectedDataSetIdentifier != null) {
                for (DataSet dataSet : dataSets) {
                    if (!dataSet.getIdentifier().equals(selectedDataSetIdentifier)) continue;
                    selectedDataSet = dataSet;
                    break;
                }
                if (selectedDataSet == null) {
                    throw new IllegalArgumentException(selectedDataSetIdentifier + " is not a valid data set identifier");
                }
            } else {
                selectedDataSet = (DataSet)dataSets.iterator().next();
            }
            model.addAttribute("selectedDataSet", (Object)selectedDataSet);
        }
        return "view-annotation-ui";
    }

    @RequestMapping(value={"/change-selected-dataset"})
    @ResponseBody
    public Map<String, Boolean> changeSelectedDataSet(@RequestBody String selectedDataSetIdentifier, Model model) {
        Map<String, Boolean> annotatorMap = this.setMapOfAnnotators(selectedDataSetIdentifier);
        return annotatorMap;
    }

    @RequestMapping(value={"/file-upload"}, headers={"content-type=multipart/*"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void handleAnnotatorFileUpload(@RequestParam(value="file-input-field") Part part, @RequestParam(value="dataset-name") String submittedDataSetName) throws IOException {
        if (part == null) {
            throw new RuntimeException("No file submitted");
        }
        String file = "input-file";
        this.fileStore.store(part.getInputStream(), file);
        this.pluginAnnotatorsUIService.tsvToOmxRepository(file, submittedDataSetName);
    }

    @RequestMapping(value={"/execute-annotation-app"}, method={RequestMethod.POST})
    public String filterMyVariants(@RequestParam(value="annotatorNames", required=false) String[] annotatorNames, Model model, @RequestParam(value="dataset-identifier") String dataSetIdentifier) {
        OmxDataSetAnnotator omxDataSetAnnotator = new OmxDataSetAnnotator(this.dataService, this.searchService, this.indexer, this.entityValidator);
        Repository repository = this.dataService.getRepositoryByEntityName(dataSetIdentifier);
        if (annotatorNames != null && repository != null) {
            for (String annotatorName : annotatorNames) {
                RepositoryAnnotator annotator = this.annotationService.getAnnotatorByName(annotatorName);
                if (annotator == null) continue;
                while (this.indexer.isIndexingRunning()) {
                }
                omxDataSetAnnotator.annotate(annotator, repository, false);
            }
        }
        return "view-result-page";
    }

    private Map<String, Boolean> setMapOfAnnotators(String dataSetIdentifier) {
        HashMap<String, Boolean> mapOfAnnotators = new HashMap<String, Boolean>();
        if (dataSetIdentifier != null) {
            EntityMetaData entityMetaData = this.dataService.getEntityMetaData(dataSetIdentifier);
            for (RepositoryAnnotator annotator : this.annotationService.getAllAnnotators()) {
                mapOfAnnotators.put(annotator.getName(), annotator.canAnnotate(entityMetaData));
            }
        }
        return mapOfAnnotators;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Map<String, String> handleRuntimeException(RuntimeException e) {
        logger.error(null, (Throwable)e);
        return Collections.singletonMap("errorMessage", "An error occured. Please contact the administrator.<br />Message:" + e.getMessage());
    }
}

