/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.annotators.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.annotators.ui.AnnotatorsUIService;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.omx.OmxRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.omx.converters.ValueConverter;
import org.molgenis.omx.converters.ValueConverterException;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.omx.search.DataSetsIndexer;
import org.molgenis.search.SearchService;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnnotatorsUIServiceImpl
implements AnnotatorsUIService {
    @Autowired
    DataService dataService;
    @Autowired
    SearchService searchService;
    @Autowired
    FileStore fileStore;
    @Autowired
    DataSetsIndexer indexer;
    @Autowired
    EntityValidator entityValidator;

    @Override
    public void tsvToOmxRepository(String file, String submittedDataSetName) {
        DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)(submittedDataSetName + "_ID")), DataSet.class);
        if (dataSet == null) {
            dataSet = this.createNewDataSet(submittedDataSetName);
        }
        DefaultEntityMetaData metaData = new DefaultEntityMetaData(submittedDataSetName + "_METADATA");
        try {
            Iterator<Entity> entityIterator = this.retrieveValuesFromFile(dataSet, metaData, file, submittedDataSetName);
            while (entityIterator.hasNext()) {
                Entity entity = entityIterator.next();
                ObservationSet os = new ObservationSet();
                os.setIdentifier(UUID.randomUUID().toString());
                os.setPartOfDataSet(dataSet);
                this.dataService.add("ObservationSet", (Entity)os);
                for (String columnName : this.getMetadataNamesAsList((EntityMetaData)metaData)) {
                    this.addValue(entity, os, columnName, submittedDataSetName);
                }
            }
            this.indexResultDataSet(dataSet);
            this.dataService.addRepository((Repository)new OmxRepository(this.dataService, this.searchService, dataSet.getIdentifier(), this.entityValidator));
        }
        catch (ValueConverterException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Iterator<Entity> retrieveValuesFromFile(DataSet dataSet, DefaultEntityMetaData metaData, String file, String submittedDataSetName) throws IOException {
        ArrayList<MapEntity> results = new ArrayList<MapEntity>();
        File uploadedFile = this.fileStore.getFile(file);
        FileReader reader = new FileReader(uploadedFile);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            boolean reachedData = false;
            boolean readHeader = false;
            String[] features = null;
            while (bufferedReader.ready()) {
                String line = bufferedReader.readLine();
                if (!line.startsWith("#")) {
                    reachedData = true;
                }
                if (!reachedData) continue;
                if (!readHeader) {
                    for (String feature : features = line.split("\t")) {
                        if (feature.equalsIgnoreCase("POS")) {
                            metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(feature, MolgenisFieldTypes.FieldTypeEnum.LONG));
                            continue;
                        }
                        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(feature, MolgenisFieldTypes.FieldTypeEnum.STRING));
                    }
                    Protocol newRootProtocol = (Protocol)this.dataService.findOne("Protocol", new QueryImpl().eq("Identifier", (Object)(submittedDataSetName + "_PROTOCOL_ID")), Protocol.class);
                    if (newRootProtocol == null) {
                        newRootProtocol = this.createAnnotationResultProtocol(dataSet, metaData.getAttributes(), submittedDataSetName);
                    }
                    dataSet.setProtocolUsed(newRootProtocol);
                    this.dataService.add("DataSet", (Entity)dataSet);
                    readHeader = true;
                    continue;
                }
                int count = 0;
                String[] values = line.split("\t", -1);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                for (String columnName : this.getMetadataNamesAsList((EntityMetaData)metaData)) {
                    resultMap.put(columnName, values[count]);
                    ++count;
                }
                results.add(new MapEntity(resultMap));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            bufferedReader.close();
        }
        return results.iterator();
    }

    private DataSet createNewDataSet(String submittedDataSetName) {
        DataSet dataSet = new DataSet();
        dataSet.setIdentifier(submittedDataSetName + "_ID");
        dataSet.setName(submittedDataSetName);
        return dataSet;
    }

    private Protocol createAnnotationResultProtocol(DataSet dataSet, Iterable<AttributeMetaData> outputMetadataNames, String submittedDataSetName) {
        Protocol newRootProtocol = new Protocol();
        newRootProtocol.setIdentifier(submittedDataSetName + "_PROTOCOL_ID");
        newRootProtocol.setName(submittedDataSetName + "_PROTOCOL_NAME");
        this.dataService.add("Protocol", (Entity)newRootProtocol);
        this.addOutputFeatures(newRootProtocol, outputMetadataNames, submittedDataSetName);
        return newRootProtocol;
    }

    private List<String> getMetadataNamesAsList(EntityMetaData metadata) {
        Iterator metadataIterator = metadata.getAttributes().iterator();
        ArrayList<String> inputFeatureNames = new ArrayList<String>();
        while (metadataIterator.hasNext()) {
            AttributeMetaData attributeMetaData = (AttributeMetaData)metadataIterator.next();
            inputFeatureNames.add(attributeMetaData.getName());
        }
        return inputFeatureNames;
    }

    private void addOutputFeatures(Protocol newRootProtocol, Iterable<AttributeMetaData> metaData, String prefix) {
        for (AttributeMetaData attributeMetaData : metaData) {
            ObservableFeature newFeature = new ObservableFeature();
            if (this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)attributeMetaData.getName())) == null) {
                newFeature.setIdentifier(attributeMetaData.getName());
                newFeature.setName(attributeMetaData.getLabel());
                newFeature.setDataType(attributeMetaData.getDataType().toString());
                this.dataService.add("ObservableFeature", (Entity)newFeature);
                newRootProtocol.getFeatures().add(newFeature);
            }
            this.dataService.update("Protocol", (Entity)newRootProtocol);
        }
    }

    private void addValue(Entity entity, ObservationSet os, String columnName, String prefix) throws ValueConverterException {
        ObservableFeature thisFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)columnName), ObservableFeature.class);
        ValueConverter valueConverter = new ValueConverter(this.dataService);
        Value value = valueConverter.fromEntity(entity, columnName, thisFeature);
        this.dataService.add("Value", (Entity)value);
        ObservedValue observedValue = new ObservedValue();
        observedValue.setFeature(thisFeature);
        observedValue.setObservationSet(os);
        observedValue.setValue(value);
        this.dataService.add("ObservedValue", (Entity)observedValue);
    }

    private void indexResultDataSet(DataSet dataSet) {
        ArrayList<Integer> datasetIds = new ArrayList<Integer>();
        datasetIds.add(dataSet.getId());
        this.indexer.indexDataSets(datasetIds);
    }
}

