/* File:        org.molgenis.omx/model/Person.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        August 21, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class PersonJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.auth.Person>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PersonJpaMapper.class);

	public PersonJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Person.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Person.Address"
			+", Person.Phone"
			+", Person.Email"
			+", Person.Fax"
			+", Person.tollFreePhone"
			+", Person.City"
			+", Person.Country"
			+", Person.FirstName"
			+", Person.MidInitials"
			+", Person.LastName"
			+", Person.Title"
			+", Person.Affiliation"
			+", Person.Department"
			+", Person.Roles"
			//parent is SimpleTree(name='Affiliation')
			+", xref_Affiliation.Name AS Affiliation_Name"
			//parent is SimpleTree(name='Roles')
			+", xref_Roles.Identifier AS Roles_Identifier"
			+" FROM Person "
			+" INNER JOIN Characteristic ON (Person.id = Characteristic.id)"

			
			//label for Affiliation=Name
//path==Affiliation. type==xref.
//path==Affiliation_Name. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Institute AS xref_Affiliation " 
			+" ON xref_Affiliation.id = Person.Affiliation"
			
			//label for Roles=Identifier
//path==Roles. type==xref.
//path==Roles_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Roles " 
			+" ON xref_Roles.id = Person.Roles"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.auth.Person entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Affiliation' is known in the databse
			if(entity.getAffiliation() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getAffiliation().getIdValue() == null)
					new org.molgenis.omx.auth.db.InstituteJpaMapper(getDatabase()).create(entity.getAffiliation());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getAffiliation()) && entity.getAffiliation().getIdValue() != null)
					entity.setAffiliation(getEntityManager().getReference(org.molgenis.omx.auth.Institute.class, entity.getAffiliation().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getAffiliation_Id() != null) {
					entity.setAffiliation((org.molgenis.omx.auth.Institute)getEntityManager().find(org.molgenis.omx.auth.Institute.class, entity.getAffiliation_Id()));
				}
			}
			//check if the object refered by 'Roles' is known in the databse
			if(entity.getRoles() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getRoles().getIdValue() == null)
					new org.molgenis.omx.auth.db.PersonRoleJpaMapper(getDatabase()).create(entity.getRoles());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getRoles()) && entity.getRoles().getIdValue() != null)
					entity.setRoles(getEntityManager().getReference(org.molgenis.omx.auth.PersonRole.class, entity.getRoles().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getRoles_Id() != null) {
					entity.setRoles((org.molgenis.omx.auth.PersonRole)getEntityManager().find(org.molgenis.omx.auth.PersonRole.class, entity.getRoles_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.auth.Person person) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				person = getEntityManager().getReference(org.molgenis.omx.auth.Person.class, person.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The person with id " + person.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(person);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.auth.Person person) throws org.molgenis.framework.db.DatabaseException {
		try {


















			//3
			org.molgenis.omx.auth.Institute affiliationNew = person.getAffiliation();

			if (affiliationNew == null) { //object is reference by xref		
                            if(person.getAffiliation_Id() != null) {
                                person.setAffiliation((org.molgenis.omx.auth.Institute)getEntityManager().find(org.molgenis.omx.auth.Institute.class, person.getAffiliation_Id()));
                            }
			}



			//3
			org.molgenis.omx.auth.PersonRole rolesNew = person.getRoles();

			if (rolesNew == null) { //object is reference by xref		
                            if(person.getRoles_Id() != null) {
                                person.setRoles((org.molgenis.omx.auth.PersonRole)getEntityManager().find(org.molgenis.omx.auth.PersonRole.class, person.getRoles_Id()));
                            }
			}
			if(!getEntityManager().contains(person)) {
				person = getEntityManager().merge(person);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.auth.Person> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.auth.Person person : entities) 
			{
				create(person);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.auth.Person> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.auth.Person person : entities) 
			{
				edit(person);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.auth.Person> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.auth.Person person : entities) 
			{
				destroy(person);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Person_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Person_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Person_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Person___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Person_description".equalsIgnoreCase(fieldName)) return "description";
		if("Address".equalsIgnoreCase(fieldName)) return "Address";
		if("Person_Address".equalsIgnoreCase(fieldName)) return "Address";
		if("Phone".equalsIgnoreCase(fieldName)) return "Phone";
		if("Person_Phone".equalsIgnoreCase(fieldName)) return "Phone";
		if("Email".equalsIgnoreCase(fieldName)) return "Email";
		if("Person_Email".equalsIgnoreCase(fieldName)) return "Email";
		if("Fax".equalsIgnoreCase(fieldName)) return "Fax";
		if("Person_Fax".equalsIgnoreCase(fieldName)) return "Fax";
		if("tollFreePhone".equalsIgnoreCase(fieldName)) return "tollFreePhone";
		if("Person_tollFreePhone".equalsIgnoreCase(fieldName)) return "tollFreePhone";
		if("City".equalsIgnoreCase(fieldName)) return "City";
		if("Person_City".equalsIgnoreCase(fieldName)) return "City";
		if("Country".equalsIgnoreCase(fieldName)) return "Country";
		if("Person_Country".equalsIgnoreCase(fieldName)) return "Country";
		if("FirstName".equalsIgnoreCase(fieldName)) return "FirstName";
		if("Person_FirstName".equalsIgnoreCase(fieldName)) return "FirstName";
		if("MidInitials".equalsIgnoreCase(fieldName)) return "MidInitials";
		if("Person_MidInitials".equalsIgnoreCase(fieldName)) return "MidInitials";
		if("LastName".equalsIgnoreCase(fieldName)) return "LastName";
		if("Person_LastName".equalsIgnoreCase(fieldName)) return "LastName";
		if("Title".equalsIgnoreCase(fieldName)) return "Title";
		if("Person_Title".equalsIgnoreCase(fieldName)) return "Title";
		if("Affiliation".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Person_Affiliation".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Department".equalsIgnoreCase(fieldName)) return "Department";
		if("Person_Department".equalsIgnoreCase(fieldName)) return "Department";
		if("Roles".equalsIgnoreCase(fieldName)) return "Roles";
		if("Person_Roles".equalsIgnoreCase(fieldName)) return "Roles";
		if("Affiliation_id".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Person_Affiliation_id".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Affiliation_Name".equalsIgnoreCase(fieldName)) return "Affiliation.Name";	
		if("Person_Affiliation_Name".equalsIgnoreCase(fieldName)) return "Affiliation.Name";
		if("Roles_id".equalsIgnoreCase(fieldName)) return "Roles";
		if("Person_Roles_id".equalsIgnoreCase(fieldName)) return "Roles";
		if("Roles_Identifier".equalsIgnoreCase(fieldName)) return "Roles.Identifier";	
		if("Person_Roles_Identifier".equalsIgnoreCase(fieldName)) return "Roles.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.auth.Person> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.auth.Person>(size);
	}			

	@Override
	public org.molgenis.omx.auth.Person create()
	{
		return new org.molgenis.omx.auth.Person();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.auth.Person> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'affiliation' to institute.id using Name)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> affiliationRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'roles' to personRole.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> rolesRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.auth.Person object: entities)
		{
			//create xref/mref rule filtering Institute on the label Name
			if(object.getAffiliation_Id() == null && object.getAffiliation_Name() != null)
			{
				Object label = object.getAffiliation_Name();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Name", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !affiliationRules.containsKey(label))
					{
						affiliationRules.put(""+label, xrefFilter);
						affiliationRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering PersonRole on the label Identifier
			if(object.getRoles_Id() == null && object.getRoles_Identifier() != null)
			{
				Object label = object.getRoles_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !rolesRules.containsKey(label))
					{
						rolesRules.put(""+label, xrefFilter);
						rolesRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'affiliation' to institute.id using Name)
		final java.util.Map<String,Integer> affiliation_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(affiliationRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.auth.Institute> affiliationList = null;
			try
			{
				affiliationList = getDatabase().find(org.molgenis.omx.auth.Institute.class, affiliationRules.values().toArray(new org.molgenis.framework.db.QueryRule[affiliationRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.auth.Institute xref :  affiliationList)
			{
				String key = "";
				key += 	xref.getName();
				
				affiliation_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'roles' to personRole.id using Identifier)
		final java.util.Map<String,Integer> roles_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(rolesRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.auth.PersonRole> rolesList = null;
			try
			{
				rolesList = getDatabase().find(org.molgenis.omx.auth.PersonRole.class, rolesRules.values().toArray(new org.molgenis.framework.db.QueryRule[rolesRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.auth.PersonRole xref :  rolesList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				roles_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.auth.Person object = entities.get(i);		
			//update object using label fields Name
			if(object.getAffiliation_Id() == null )
			{
					String key = "";
					if(object.getAffiliation_Name() != null)
						key += 	object.getAffiliation_Name();
					
					if(!"".equals(key) && affiliation_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Affiliation_Name cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setAffiliation_Id(affiliation_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getRoles_Id() == null )
			{
					String key = "";
					if(object.getRoles_Identifier() != null)
						key += 	object.getRoles_Identifier();
					
					if(!"".equals(key) && roles_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Roles_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setRoles_Id(roles_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "person.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("address".equalsIgnoreCase(fieldName) || "person.address".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("phone".equalsIgnoreCase(fieldName) || "person.phone".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("email".equalsIgnoreCase(fieldName) || "person.email".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("fax".equalsIgnoreCase(fieldName) || "person.fax".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("tollFreePhone".equalsIgnoreCase(fieldName) || "person.tollFreePhone".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("city".equalsIgnoreCase(fieldName) || "person.city".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("country".equalsIgnoreCase(fieldName) || "person.country".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("firstName".equalsIgnoreCase(fieldName) || "person.firstName".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("midInitials".equalsIgnoreCase(fieldName) || "person.midInitials".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("lastName".equalsIgnoreCase(fieldName) || "person.lastName".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("title".equalsIgnoreCase(fieldName) || "person.title".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("affiliation".equalsIgnoreCase(fieldName) || "person.affiliation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("department".equalsIgnoreCase(fieldName) || "person.department".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("roles".equalsIgnoreCase(fieldName) || "person.roles".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.auth.Person> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.auth.Person> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
