
/* File:        org.molgenis.omx/model/MolgenisUser.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.auth;

/**
 * MolgenisUser: Anyone who can login.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "MolgenisUser", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "Email" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.auth.db.MolgenisUserEntityListener.class})
public class MolgenisUser extends org.molgenis.omx.auth.MolgenisRole implements org.molgenis.omx.auth.Contact, org.molgenis.omx.auth.PersonContact
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String ADDRESS = "Address";
	public final static String PHONE = "Phone";
	public final static String EMAIL = "Email";
	public final static String FAX = "Fax";
	public final static String TOLLFREEPHONE = "tollFreePhone";
	public final static String CITY = "City";
	public final static String COUNTRY = "Country";
	public final static String FIRSTNAME = "FirstName";
	public final static String MIDINITIALS = "MidInitials";
	public final static String LASTNAME = "LastName";
	public final static String TITLE = "Title";
	public final static String AFFILIATION = "Affiliation";
	public final static String AFFILIATION_NAME = "Affiliation_Name";
	public final static String DEPARTMENT = "Department";
	public final static String ROLES = "Roles";
	public final static String ROLES_IDENTIFIER = "Roles_Identifier";
	public final static String PASSWORD_ = "password_";
	public final static String ACTIVATIONCODE = "activationCode";
	public final static String ACTIVE = "active";
	public final static String SUPERUSER = "superuser";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(MolgenisUser.class).
	 */
	public static org.molgenis.framework.db.Query<? extends MolgenisUser> query(org.molgenis.framework.db.Database db)
	{
		return db.query(MolgenisUser.class);
	}
	
	/**
	 * Shorthand for db.find(MolgenisUser.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends MolgenisUser> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(MolgenisUser.class, rules);
	}	
	
	/**
	 * 
	 */
	public static MolgenisUser findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<MolgenisUser> q = db.query(MolgenisUser.class);
		q.eq(MolgenisUser.ID, id);
		java.util.List<MolgenisUser> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static MolgenisUser findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<MolgenisUser> q = db.query(MolgenisUser.class);
		q.eq(MolgenisUser.IDENTIFIER, identifier);
		java.util.List<MolgenisUser> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static MolgenisUser findByName(org.molgenis.framework.db.Database db, String name) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<MolgenisUser> q = db.query(MolgenisUser.class);
		q.eq(MolgenisUser.NAME, name);
		java.util.List<MolgenisUser> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static MolgenisUser findByEmail(org.molgenis.framework.db.Database db, String email) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<MolgenisUser> q = db.query(MolgenisUser.class);
		q.eq(MolgenisUser.EMAIL, email);
		java.util.List<MolgenisUser> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//The address of the Contact.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Address")
	
				

	private String address =  null;

	//The telephone number of the Contact including the suitable area codes.[type=string]
	@javax.persistence.Column(name="Phone", length=255)
	@javax.xml.bind.annotation.XmlElement(name="phone")
	
				

	private String phone =  null;

	//The email address of the Contact.[type=string]
//	@org.hibernate.search.annotations.Field(index=org.hibernate.search.annotations.Index.TOKENIZED, store=org.hibernate.search.annotations.Store.NO)
	@javax.persistence.Column(name="Email", length=255)
	@javax.xml.bind.annotation.XmlElement(name="email")
	
				

	private String email =  null;

	//The fax number of the Contact.[type=string]
	@javax.persistence.Column(name="Fax", length=255)
	@javax.xml.bind.annotation.XmlElement(name="fax")
	
				

	private String fax =  null;

	//A toll free phone number for the Contact, including suitable area codes.[type=string]
	@javax.persistence.Column(name="tollFreePhone", length=255)
	@javax.xml.bind.annotation.XmlElement(name="tollFreePhone")
	
				

	private String tollFreePhone =  null;

	//Added from the old definition of MolgenisUser. City of this contact.[type=string]
	@javax.persistence.Column(name="City", length=255)
	@javax.xml.bind.annotation.XmlElement(name="city")
	
				

	private String city =  null;

	//Added from the old definition of MolgenisUser. Country of this contact.[type=string]
	@javax.persistence.Column(name="Country", length=255)
	@javax.xml.bind.annotation.XmlElement(name="country")
	
				

	private String country =  null;

	//First Name[type=string]
	@javax.persistence.Column(name="FirstName", length=255)
	@javax.xml.bind.annotation.XmlElement(name="firstName")
	
				

	private String firstName =  null;

	//Mid Initials[type=string]
	@javax.persistence.Column(name="MidInitials", length=255)
	@javax.xml.bind.annotation.XmlElement(name="midInitials")
	
				

	private String midInitials =  null;

	//Last Name[type=string]
	@javax.persistence.Column(name="LastName", length=255)
	@javax.xml.bind.annotation.XmlElement(name="lastName")
	
				

	private String lastName =  null;

	//An academic title, e.g. Prof.dr, PhD[type=string]
	@javax.persistence.Column(name="Title", length=255)
	@javax.xml.bind.annotation.XmlElement(name="title")
	
				

	private String title =  null;

	//Affiliation[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Affiliation")   	
	
				

	private org.molgenis.omx.auth.Institute affiliation = null;
	@javax.persistence.Transient
	private Integer affiliation_id = null;	
	@javax.persistence.Transient
	private String affiliation_Name = null;						

	//Added from the old definition of MolgenisUser. Department of this contact.[type=string]
	@javax.persistence.Column(name="Department", length=255)
	@javax.xml.bind.annotation.XmlElement(name="department")
	
				

	private String department =  null;

	//Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Roles")   	
	
				

	private org.molgenis.omx.auth.PersonRole roles = null;
	@javax.persistence.Transient
	private Integer roles_id = null;	
	@javax.persistence.Transient
	private String roles_Identifier = null;						

	//big fixme: password type[type=string]
	@javax.persistence.Column(name="password_", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="password_")
	
				

	@javax.validation.constraints.NotNull
	private String password_ =  "secret";

	//Used as alternative authentication mechanism to verify user email and/or if user has lost password.[type=string]
	@javax.persistence.Column(name="activationCode", length=255)
	@javax.xml.bind.annotation.XmlElement(name="activationCode")
	
				

	private String activationCode =  null;

	//Boolean to indicate if this account can be used to login[type=bool]
	@javax.persistence.Column(name="active", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="active")
	
				

	@javax.validation.constraints.NotNull
	private Boolean active =  false;

	//superuser[type=bool]
	@javax.persistence.Column(name="superuser", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="superuser")
	
				

	@javax.validation.constraints.NotNull
	private Boolean superuser =  false;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public MolgenisUser()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public MolgenisUser(MolgenisUser copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the The address of the Contact..
	 * @return address.
	 */
	public String getAddress()
	{
		return this.address;
	}
	
	@Deprecated
	public String getAddress(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The address of the Contact..
	 * @param address
	 */
	public void setAddress( String address)
	{
		
		this.address = address;
	}

	

	/**
	 * Get the The telephone number of the Contact including the suitable area codes..
	 * @return phone.
	 */
	public String getPhone()
	{
		return this.phone;
	}
	
	@Deprecated
	public String getPhone(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The telephone number of the Contact including the suitable area codes..
	 * @param phone
	 */
	public void setPhone( String phone)
	{
		
		this.phone = phone;
	}

	

	/**
	 * Get the The email address of the Contact..
	 * @return email.
	 */
	public String getEmail()
	{
		return this.email;
	}
	
	@Deprecated
	public String getEmail(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The email address of the Contact..
	 * @param email
	 */
	public void setEmail( String email)
	{
		
		this.email = email;
	}

	

	/**
	 * Get the The fax number of the Contact..
	 * @return fax.
	 */
	public String getFax()
	{
		return this.fax;
	}
	
	@Deprecated
	public String getFax(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The fax number of the Contact..
	 * @param fax
	 */
	public void setFax( String fax)
	{
		
		this.fax = fax;
	}

	

	/**
	 * Get the A toll free phone number for the Contact, including suitable area codes..
	 * @return tollFreePhone.
	 */
	public String getTollFreePhone()
	{
		return this.tollFreePhone;
	}
	
	@Deprecated
	public String getTollFreePhone(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the A toll free phone number for the Contact, including suitable area codes..
	 * @param tollFreePhone
	 */
	public void setTollFreePhone( String tollFreePhone)
	{
		
		this.tollFreePhone = tollFreePhone;
	}

	

	/**
	 * Get the Added from the old definition of MolgenisUser. City of this contact..
	 * @return city.
	 */
	public String getCity()
	{
		return this.city;
	}
	
	@Deprecated
	public String getCity(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Added from the old definition of MolgenisUser. City of this contact..
	 * @param city
	 */
	public void setCity( String city)
	{
		
		this.city = city;
	}

	

	/**
	 * Get the Added from the old definition of MolgenisUser. Country of this contact..
	 * @return country.
	 */
	public String getCountry()
	{
		return this.country;
	}
	
	@Deprecated
	public String getCountry(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Added from the old definition of MolgenisUser. Country of this contact..
	 * @param country
	 */
	public void setCountry( String country)
	{
		
		this.country = country;
	}

	

	/**
	 * Get the First Name.
	 * @return firstName.
	 */
	public String getFirstName()
	{
		return this.firstName;
	}
	
	@Deprecated
	public String getFirstName(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the First Name.
	 * @param firstName
	 */
	public void setFirstName( String firstName)
	{
		
		this.firstName = firstName;
	}

	

	/**
	 * Get the Mid Initials.
	 * @return midInitials.
	 */
	public String getMidInitials()
	{
		return this.midInitials;
	}
	
	@Deprecated
	public String getMidInitials(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Mid Initials.
	 * @param midInitials
	 */
	public void setMidInitials( String midInitials)
	{
		
		this.midInitials = midInitials;
	}

	

	/**
	 * Get the Last Name.
	 * @return lastName.
	 */
	public String getLastName()
	{
		return this.lastName;
	}
	
	@Deprecated
	public String getLastName(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Last Name.
	 * @param lastName
	 */
	public void setLastName( String lastName)
	{
		
		this.lastName = lastName;
	}

	

	/**
	 * Get the An academic title, e.g. Prof.dr, PhD.
	 * @return title.
	 */
	public String getTitle()
	{
		return this.title;
	}
	
	@Deprecated
	public String getTitle(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the An academic title, e.g. Prof.dr, PhD.
	 * @param title
	 */
	public void setTitle( String title)
	{
		
		this.title = title;
	}

	

	/**
	 * Get the Affiliation.
	 * @return affiliation.
	 */
	public org.molgenis.omx.auth.Institute getAffiliation()
	{
		return this.affiliation;
	}
	
	@Deprecated
	public org.molgenis.omx.auth.Institute getAffiliation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Affiliation.
	 * @param affiliation
	 */
	public void setAffiliation( org.molgenis.omx.auth.Institute affiliation)
	{
		
		this.affiliation = affiliation;
	}

	
	
	/**
	 * Set foreign key for field affiliation.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setAffiliation_Id(Integer affiliation_id)
	{
		this.affiliation_id = affiliation_id;
	}	

	public void setAffiliation(Integer affiliation_id)
	{
		this.affiliation_id = affiliation_id;
	}
	
	public Integer getAffiliation_Id()
	{
		
		if(affiliation != null) 
		{
			return affiliation.getId();
		}
		else
		{
			return affiliation_id;
		}
	}	
	 
	/**
	 * Get a pretty label Name for cross reference Affiliation to Institute.Id.
	 */
	public String getAffiliation_Name()
	{		
		//FIXME should we auto-load based on getAffiliation()?	
		if(affiliation != null) {
			return affiliation.getName();
		} else {
			return affiliation_Name;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Affiliation to <a href="Institute.html#Id">Institute.Id</a>.
	 * Implies setAffiliation(null) until save
	 */
	public void setAffiliation_Name(String affiliation_Name)
	{
		this.affiliation_Name = affiliation_Name;
	}		
	 
	

	/**
	 * Get the Added from the old definition of MolgenisUser. Department of this contact..
	 * @return department.
	 */
	public String getDepartment()
	{
		return this.department;
	}
	
	@Deprecated
	public String getDepartment(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Added from the old definition of MolgenisUser. Department of this contact..
	 * @param department
	 */
	public void setDepartment( String department)
	{
		
		this.department = department;
	}

	

	/**
	 * Get the Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011..
	 * @return roles.
	 */
	public org.molgenis.omx.auth.PersonRole getRoles()
	{
		return this.roles;
	}
	
	@Deprecated
	public org.molgenis.omx.auth.PersonRole getRoles(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011..
	 * @param roles
	 */
	public void setRoles( org.molgenis.omx.auth.PersonRole roles)
	{
		
		this.roles = roles;
	}

	
	
	/**
	 * Set foreign key for field roles.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setRoles_Id(Integer roles_id)
	{
		this.roles_id = roles_id;
	}	

	public void setRoles(Integer roles_id)
	{
		this.roles_id = roles_id;
	}
	
	public Integer getRoles_Id()
	{
		
		if(roles != null) 
		{
			return roles.getId();
		}
		else
		{
			return roles_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Roles to PersonRole.Id.
	 */
	public String getRoles_Identifier()
	{		
		//FIXME should we auto-load based on getRoles()?	
		if(roles != null) {
			return roles.getIdentifier();
		} else {
			return roles_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Roles to <a href="PersonRole.html#Id">PersonRole.Id</a>.
	 * Implies setRoles(null) until save
	 */
	public void setRoles_Identifier(String roles_Identifier)
	{
		this.roles_Identifier = roles_Identifier;
	}		
	 
	

	/**
	 * Get the big fixme: password type.
	 * @return password_.
	 */
	public String getPassword()
	{
		return this.password_;
	}
	
	@Deprecated
	public String getPassword(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the big fixme: password type.
	 * @param password_
	 */
	public void setPassword( String password_)
	{
		
		this.password_ = password_;
	}

	

	/**
	 * Get the Used as alternative authentication mechanism to verify user email and/or if user has lost password..
	 * @return activationCode.
	 */
	public String getActivationCode()
	{
		return this.activationCode;
	}
	
	@Deprecated
	public String getActivationCode(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Used as alternative authentication mechanism to verify user email and/or if user has lost password..
	 * @param activationCode
	 */
	public void setActivationCode( String activationCode)
	{
		
		this.activationCode = activationCode;
	}

	

	/**
	 * Get the Boolean to indicate if this account can be used to login.
	 * @return active.
	 */
	public Boolean getActive()
	{
		return this.active;
	}
	
	@Deprecated
	public Boolean getActive(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Boolean to indicate if this account can be used to login.
	 * @param active
	 */
	public void setActive( Boolean active)
	{
		
		this.active = active;
	}

	

	/**
	 * Get the superuser.
	 * @return superuser.
	 */
	public Boolean getSuperuser()
	{
		return this.superuser;
	}
	
	@Deprecated
	public Boolean getSuperuser(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the superuser.
	 * @param superuser
	 */
	public void setSuperuser( Boolean superuser)
	{
		
		this.superuser = superuser;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("address"))
			return getAddress();
		if (name.equals("phone"))
			return getPhone();
		if (name.equals("email"))
			return getEmail();
		if (name.equals("fax"))
			return getFax();
		if (name.equals("tollfreephone"))
			return getTollFreePhone();
		if (name.equals("city"))
			return getCity();
		if (name.equals("country"))
			return getCountry();
		if (name.equals("firstname"))
			return getFirstName();
		if (name.equals("midinitials"))
			return getMidInitials();
		if (name.equals("lastname"))
			return getLastName();
		if (name.equals("title"))
			return getTitle();
		if (name.equals("affiliation"))
			return getAffiliation();
		if(name.equals("affiliation_id"))
			return getAffiliation_Id();
		if(name.equals("affiliation_name"))
			return getAffiliation_Name();
		if (name.equals("department"))
			return getDepartment();
		if (name.equals("roles"))
			return getRoles();
		if(name.equals("roles_id"))
			return getRoles_Id();
		if(name.equals("roles_identifier"))
			return getRoles_Identifier();
		if (name.equals("password_"))
			return getPassword();
		if (name.equals("activationcode"))
			return getActivationCode();
		if (name.equals("active"))
			return getActive();
		if (name.equals("superuser"))
			return getSuperuser();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getPassword() == null) throw new org.molgenis.framework.db.DatabaseException("required field password_ is null");
		if(this.getActive() == null) throw new org.molgenis.framework.db.DatabaseException("required field active is null");
		if(this.getSuperuser() == null) throw new org.molgenis.framework.db.DatabaseException("required field superuser is null");
	}
	
	@Override
	public void set(org.molgenis.util.tuple.Tuple tuple, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(tuple.getInt("id") != null) this.setId(tuple.getInt("id"));
		else if(strict) this.setId(tuple.getInt("id")); // setting null is not an option due to function overloading
		if( tuple.getInt("molgenisuser_id") != null) this.setId(tuple.getInt("molgenisuser_id"));
		else if( tuple.getInt("MolgenisUser_id") != null) this.setId(tuple.getInt("MolgenisUser_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(tuple.getString("identifier") != null) this.setIdentifier(tuple.getString("identifier"));
		else if(tuple.getString("Identifier") != null) this.setIdentifier(tuple.getString("Identifier"));
		else if(strict) this.setIdentifier(tuple.getString("identifier")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_identifier") != null) this.setIdentifier(tuple.getString("molgenisuser_identifier"));
		else if( tuple.getString("MolgenisUser_Identifier") != null) this.setIdentifier(tuple.getString("MolgenisUser_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(tuple.getString("name") != null) this.setName(tuple.getString("name"));
		else if(tuple.getString("Name") != null) this.setName(tuple.getString("Name"));
		else if(strict) this.setName(tuple.getString("name")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_name") != null) this.setName(tuple.getString("molgenisuser_name"));
		else if( tuple.getString("MolgenisUser_Name") != null) this.setName(tuple.getString("MolgenisUser_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(tuple.getString("__type") != null) this.set__Type(tuple.getString("__type"));
		else if(tuple.getString("__Type") != null) this.set__Type(tuple.getString("__Type"));
		else if(strict) this.set__Type(tuple.getString("__type")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser___type") != null) this.set__Type(tuple.getString("molgenisuser___type"));
		else if( tuple.getString("MolgenisUser___Type") != null) this.set__Type(tuple.getString("MolgenisUser___Type"));
		//set Address
		// query formal name, else lowercase name
		if(tuple.getString("address") != null) this.setAddress(tuple.getString("address"));
		else if(tuple.getString("Address") != null) this.setAddress(tuple.getString("Address"));
		else if(strict) this.setAddress(tuple.getString("address")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_address") != null) this.setAddress(tuple.getString("molgenisuser_address"));
		else if( tuple.getString("MolgenisUser_Address") != null) this.setAddress(tuple.getString("MolgenisUser_Address"));
		//set Phone
		// query formal name, else lowercase name
		if(tuple.getString("phone") != null) this.setPhone(tuple.getString("phone"));
		else if(tuple.getString("Phone") != null) this.setPhone(tuple.getString("Phone"));
		else if(strict) this.setPhone(tuple.getString("phone")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_phone") != null) this.setPhone(tuple.getString("molgenisuser_phone"));
		else if( tuple.getString("MolgenisUser_Phone") != null) this.setPhone(tuple.getString("MolgenisUser_Phone"));
		//set Email
		// query formal name, else lowercase name
		if(tuple.getString("email") != null) this.setEmail(tuple.getString("email"));
		else if(tuple.getString("Email") != null) this.setEmail(tuple.getString("Email"));
		else if(strict) this.setEmail(tuple.getString("email")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_email") != null) this.setEmail(tuple.getString("molgenisuser_email"));
		else if( tuple.getString("MolgenisUser_Email") != null) this.setEmail(tuple.getString("MolgenisUser_Email"));
		//set Fax
		// query formal name, else lowercase name
		if(tuple.getString("fax") != null) this.setFax(tuple.getString("fax"));
		else if(tuple.getString("Fax") != null) this.setFax(tuple.getString("Fax"));
		else if(strict) this.setFax(tuple.getString("fax")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_fax") != null) this.setFax(tuple.getString("molgenisuser_fax"));
		else if( tuple.getString("MolgenisUser_Fax") != null) this.setFax(tuple.getString("MolgenisUser_Fax"));
		//set TollFreePhone
		// query formal name, else lowercase name
		if(tuple.getString("tollfreephone") != null) this.setTollFreePhone(tuple.getString("tollfreephone"));
		else if(tuple.getString("tollFreePhone") != null) this.setTollFreePhone(tuple.getString("tollFreePhone"));
		else if(strict) this.setTollFreePhone(tuple.getString("tollfreephone")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_tollfreephone") != null) this.setTollFreePhone(tuple.getString("molgenisuser_tollfreephone"));
		else if( tuple.getString("MolgenisUser_tollFreePhone") != null) this.setTollFreePhone(tuple.getString("MolgenisUser_tollFreePhone"));
		//set City
		// query formal name, else lowercase name
		if(tuple.getString("city") != null) this.setCity(tuple.getString("city"));
		else if(tuple.getString("City") != null) this.setCity(tuple.getString("City"));
		else if(strict) this.setCity(tuple.getString("city")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_city") != null) this.setCity(tuple.getString("molgenisuser_city"));
		else if( tuple.getString("MolgenisUser_City") != null) this.setCity(tuple.getString("MolgenisUser_City"));
		//set Country
		// query formal name, else lowercase name
		if(tuple.getString("country") != null) this.setCountry(tuple.getString("country"));
		else if(tuple.getString("Country") != null) this.setCountry(tuple.getString("Country"));
		else if(strict) this.setCountry(tuple.getString("country")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_country") != null) this.setCountry(tuple.getString("molgenisuser_country"));
		else if( tuple.getString("MolgenisUser_Country") != null) this.setCountry(tuple.getString("MolgenisUser_Country"));
		//set FirstName
		// query formal name, else lowercase name
		if(tuple.getString("firstname") != null) this.setFirstName(tuple.getString("firstname"));
		else if(tuple.getString("FirstName") != null) this.setFirstName(tuple.getString("FirstName"));
		else if(strict) this.setFirstName(tuple.getString("firstname")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_firstname") != null) this.setFirstName(tuple.getString("molgenisuser_firstname"));
		else if( tuple.getString("MolgenisUser_FirstName") != null) this.setFirstName(tuple.getString("MolgenisUser_FirstName"));
		//set MidInitials
		// query formal name, else lowercase name
		if(tuple.getString("midinitials") != null) this.setMidInitials(tuple.getString("midinitials"));
		else if(tuple.getString("MidInitials") != null) this.setMidInitials(tuple.getString("MidInitials"));
		else if(strict) this.setMidInitials(tuple.getString("midinitials")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_midinitials") != null) this.setMidInitials(tuple.getString("molgenisuser_midinitials"));
		else if( tuple.getString("MolgenisUser_MidInitials") != null) this.setMidInitials(tuple.getString("MolgenisUser_MidInitials"));
		//set LastName
		// query formal name, else lowercase name
		if(tuple.getString("lastname") != null) this.setLastName(tuple.getString("lastname"));
		else if(tuple.getString("LastName") != null) this.setLastName(tuple.getString("LastName"));
		else if(strict) this.setLastName(tuple.getString("lastname")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_lastname") != null) this.setLastName(tuple.getString("molgenisuser_lastname"));
		else if( tuple.getString("MolgenisUser_LastName") != null) this.setLastName(tuple.getString("MolgenisUser_LastName"));
		//set Title
		// query formal name, else lowercase name
		if(tuple.getString("title") != null) this.setTitle(tuple.getString("title"));
		else if(tuple.getString("Title") != null) this.setTitle(tuple.getString("Title"));
		else if(strict) this.setTitle(tuple.getString("title")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_title") != null) this.setTitle(tuple.getString("molgenisuser_title"));
		else if( tuple.getString("MolgenisUser_Title") != null) this.setTitle(tuple.getString("MolgenisUser_Title"));
		//set Affiliation
		// query formal name, else lowercase name
		if(tuple.getInt("Affiliation_id") != null) this.setAffiliation(tuple.getInt("Affiliation_id"));
		else if(tuple.getInt("affiliation_id") != null) this.setAffiliation(tuple.getInt("affiliation_id"));
		else if(strict) this.setAffiliation(tuple.getInt("Affiliation_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("MolgenisUser_Affiliation_id") != null) this.setAffiliation(tuple.getInt("MolgenisUser_Affiliation_id"));
		else if( tuple.getInt("molgenisuser_affiliation_id") != null) this.setAffiliation(tuple.getInt("molgenisuser_affiliation_id"));
		//alias of xref
		if( tuple.get("Affiliation") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("Affiliation").toString())) {
				org.molgenis.omx.auth.Institute instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("Affiliation"), org.molgenis.omx.auth.Institute.class);
				this.setAffiliation(instance);				
			} else {
				this.setAffiliation_Id(tuple.getInt("Affiliation")); 
			}
		}
		else if( tuple.get("affiliation") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("affiliation").toString())) {
				org.molgenis.omx.auth.Institute instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("affiliation"), org.molgenis.omx.auth.Institute.class);
				this.setAffiliation(instance);				
			} else {
				this.setAffiliation_Id(tuple.getInt("Affiliation"));
			}
		}
		if( tuple.get("MolgenisUser_Affiliation") != null)
			this.setAffiliation_Id(tuple.getInt("MolgenisUser_Affiliation"));			
		else if( tuple.get("molgenisuser_affiliation") != null)
			this.setAffiliation_Id(tuple.getInt("molgenisuser_affiliation"));
			
		if( tuple.get("MolgenisUser.Affiliation") != null) 
			this.setAffiliation((org.molgenis.omx.auth.Institute)tuple.get("MolgenisUser.Affiliation_id"));
		else if( tuple.get("molgenisuser.affiliation") != null) 
			this.setAffiliation((org.molgenis.omx.auth.Institute)tuple.get("molgenisuser.affiliation_id"));	
		//set label for field Affiliation
		if(tuple.get("Affiliation_Name") != null) this.setAffiliation_Name(tuple.getString("Affiliation_Name"));
		else if(tuple.get("affiliation_name") != null) this.setAffiliation_Name(tuple.getString("affiliation_name"));
		else if(strict) this.setAffiliation_Name(tuple.getString("Affiliation_Name")); // setting null is not an option due to function overloading
		if( tuple.get("MolgenisUser_Affiliation_Name") != null ) this.setAffiliation_Name(tuple.getString("MolgenisUser_Affiliation_Name"));		
		else if( tuple.get("molgenisuser_affiliation_name") != null ) this.setAffiliation_Name(tuple.getString("molgenisuser_affiliation_name"));
		//set Department
		// query formal name, else lowercase name
		if(tuple.getString("department") != null) this.setDepartment(tuple.getString("department"));
		else if(tuple.getString("Department") != null) this.setDepartment(tuple.getString("Department"));
		else if(strict) this.setDepartment(tuple.getString("department")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_department") != null) this.setDepartment(tuple.getString("molgenisuser_department"));
		else if( tuple.getString("MolgenisUser_Department") != null) this.setDepartment(tuple.getString("MolgenisUser_Department"));
		//set Roles
		// query formal name, else lowercase name
		if(tuple.getInt("Roles_id") != null) this.setRoles(tuple.getInt("Roles_id"));
		else if(tuple.getInt("roles_id") != null) this.setRoles(tuple.getInt("roles_id"));
		else if(strict) this.setRoles(tuple.getInt("Roles_id")); // setting null is not an option due to function overloading
		
		if( tuple.getInt("MolgenisUser_Roles_id") != null) this.setRoles(tuple.getInt("MolgenisUser_Roles_id"));
		else if( tuple.getInt("molgenisuser_roles_id") != null) this.setRoles(tuple.getInt("molgenisuser_roles_id"));
		//alias of xref
		if( tuple.get("Roles") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("Roles").toString())) {
				org.molgenis.omx.auth.PersonRole instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("Roles"), org.molgenis.omx.auth.PersonRole.class);
				this.setRoles(instance);				
			} else {
				this.setRoles_Id(tuple.getInt("Roles")); 
			}
		}
		else if( tuple.get("roles") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(tuple.get("roles").toString())) {
				org.molgenis.omx.auth.PersonRole instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)tuple.get("roles"), org.molgenis.omx.auth.PersonRole.class);
				this.setRoles(instance);				
			} else {
				this.setRoles_Id(tuple.getInt("Roles"));
			}
		}
		if( tuple.get("MolgenisUser_Roles") != null)
			this.setRoles_Id(tuple.getInt("MolgenisUser_Roles"));			
		else if( tuple.get("molgenisuser_roles") != null)
			this.setRoles_Id(tuple.getInt("molgenisuser_roles"));
			
		if( tuple.get("MolgenisUser.Roles") != null) 
			this.setRoles((org.molgenis.omx.auth.PersonRole)tuple.get("MolgenisUser.Roles_id"));
		else if( tuple.get("molgenisuser.roles") != null) 
			this.setRoles((org.molgenis.omx.auth.PersonRole)tuple.get("molgenisuser.roles_id"));	
		//set label for field Roles
		if(tuple.get("Roles_Identifier") != null) this.setRoles_Identifier(tuple.getString("Roles_Identifier"));
		else if(tuple.get("roles_identifier") != null) this.setRoles_Identifier(tuple.getString("roles_identifier"));
		else if(strict) this.setRoles_Identifier(tuple.getString("Roles_Identifier")); // setting null is not an option due to function overloading
		if( tuple.get("MolgenisUser_Roles_Identifier") != null ) this.setRoles_Identifier(tuple.getString("MolgenisUser_Roles_Identifier"));		
		else if( tuple.get("molgenisuser_roles_identifier") != null ) this.setRoles_Identifier(tuple.getString("molgenisuser_roles_identifier"));
		//set Password
		// query formal name, else lowercase name
		if(tuple.getString("password_") != null) this.setPassword(tuple.getString("password_"));
		else if(tuple.getString("password_") != null) this.setPassword(tuple.getString("password_"));
		else if(strict) this.setPassword(tuple.getString("password_")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_password_") != null) this.setPassword(tuple.getString("molgenisuser_password_"));
		else if( tuple.getString("MolgenisUser_password_") != null) this.setPassword(tuple.getString("MolgenisUser_password_"));
		//set ActivationCode
		// query formal name, else lowercase name
		if(tuple.getString("activationcode") != null) this.setActivationCode(tuple.getString("activationcode"));
		else if(tuple.getString("activationCode") != null) this.setActivationCode(tuple.getString("activationCode"));
		else if(strict) this.setActivationCode(tuple.getString("activationcode")); // setting null is not an option due to function overloading
		if( tuple.getString("molgenisuser_activationcode") != null) this.setActivationCode(tuple.getString("molgenisuser_activationcode"));
		else if( tuple.getString("MolgenisUser_activationCode") != null) this.setActivationCode(tuple.getString("MolgenisUser_activationCode"));
		//set Active
		// query formal name, else lowercase name
		if(tuple.getBoolean("active") != null) this.setActive(tuple.getBoolean("active"));
		else if(tuple.getBoolean("active") != null) this.setActive(tuple.getBoolean("active"));
		else if(strict) this.setActive(tuple.getBoolean("active")); // setting null is not an option due to function overloading
		if( tuple.getBoolean("molgenisuser_active") != null) this.setActive(tuple.getBoolean("molgenisuser_active"));
		else if( tuple.getBoolean("MolgenisUser_active") != null) this.setActive(tuple.getBoolean("MolgenisUser_active"));
		//set Superuser
		// query formal name, else lowercase name
		if(tuple.getBoolean("superuser") != null) this.setSuperuser(tuple.getBoolean("superuser"));
		else if(tuple.getBoolean("superuser") != null) this.setSuperuser(tuple.getBoolean("superuser"));
		else if(strict) this.setSuperuser(tuple.getBoolean("superuser")); // setting null is not an option due to function overloading
		if( tuple.getBoolean("molgenisuser_superuser") != null) this.setSuperuser(tuple.getBoolean("molgenisuser_superuser"));
		else if( tuple.getBoolean("MolgenisUser_superuser") != null) this.setSuperuser(tuple.getBoolean("MolgenisUser_superuser"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "MolgenisUser(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "address='" + getAddress()+"' ";	
		result+= "phone='" + getPhone()+"' ";	
		result+= "email='" + getEmail()+"' ";	
		result+= "fax='" + getFax()+"' ";	
		result+= "tollFreePhone='" + getTollFreePhone()+"' ";	
		result+= "city='" + getCity()+"' ";	
		result+= "country='" + getCountry()+"' ";	
		result+= "firstName='" + getFirstName()+"' ";	
		result+= "midInitials='" + getMidInitials()+"' ";	
		result+= "lastName='" + getLastName()+"' ";	
		result+= "title='" + getTitle()+"' ";	
		result+= " affiliation_id='" + getAffiliation_Id()+"' ";	
		result+= " affiliation_name='" + getAffiliation_Name()+"' ";
		result+= "department='" + getDepartment()+"' ";	
		result+= " roles_id='" + getRoles_Id()+"' ";	
		result+= " roles_identifier='" + getRoles_Identifier()+"' ";
		result+= "password_='" + getPassword()+"' ";	
		result+= "activationCode='" + getActivationCode()+"' ";	
		result+= "active='" + getActive()+"' ";	
		result+= "superuser='" + getSuperuser()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of MolgenisUser.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("Address");
		}
		{
			fields.add("Phone");
		}
		{
			fields.add("Email");
		}
		{
			fields.add("Fax");
		}
		{
			fields.add("tollFreePhone");
		}
		{
			fields.add("City");
		}
		{
			fields.add("Country");
		}
		{
			fields.add("FirstName");
		}
		{
			fields.add("MidInitials");
		}
		{
			fields.add("LastName");
		}
		{
			fields.add("Title");
		}
		{
			fields.add("Affiliation_id");
		}
		fields.add("Affiliation_Name");
		{
			fields.add("Department");
		}
		{
			fields.add("Roles_id");
		}
		fields.add("Roles_Identifier");
		{
			fields.add("password_");
		}
		{
			fields.add("activationCode");
		}
		{
			fields.add("active");
		}
		{
			fields.add("superuser");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Name");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "address" +sep
		+ "phone" +sep
		+ "email" +sep
		+ "fax" +sep
		+ "tollFreePhone" +sep
		+ "city" +sep
		+ "country" +sep
		+ "firstName" +sep
		+ "midInitials" +sep
		+ "lastName" +sep
		+ "title" +sep
		+ "affiliation" +sep
		+ "department" +sep
		+ "roles" +sep
		+ "password_" +sep
		+ "activationCode" +sep
		+ "active" +sep
		+ "superuser" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("affiliation")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("roles")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getAddress();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPhone();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getEmail();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFax();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTollFreePhone();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCity();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCountry();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getFirstName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getMidInitials();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getLastName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTitle();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getAffiliation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDepartment();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getRoles();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPassword();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getActivationCode();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getActive();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSuperuser();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public MolgenisUser create(org.molgenis.util.tuple.Tuple tuple) throws Exception
	{
		MolgenisUser e = new MolgenisUser();
		e.set(tuple);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		MolgenisUser other = (MolgenisUser) obj;
		if (email == null)
		{
			if (other.email != null) return false;
		}
		else if (!email.equals(other.email)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((email == null) ? 0 : email.hashCode());
		return result;
	}
}
