
/* File:        org.molgenis.omx/model/MolgenisRoleGroupLink.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.omx.auth.MolgenisRole;
import org.molgenis.omx.auth.MolgenisRoleGroupLink;


/**
 * Reads MolgenisRoleGroupLink from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MolgenisRoleGroupLinkEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MolgenisRoleGroupLinkEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'group_' (maps molgenisGroup.Name -> molgenisGroup.id)			
	final Map<String,Integer> group_Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'role_' (maps molgenisRole.Name -> molgenisRole.id)			
	final Map<String,Integer> role_Keymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports MolgenisRoleGroupLink from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MolgenisRoleGroupLink> molgenisRoleGroupLinksMissingRefs = new ArrayList<MolgenisRoleGroupLink>();
	
		//cache for objects to be imported from file (in batch)
		final List<MolgenisRoleGroupLink> molgenisRoleGroupLinkList = new ArrayList<MolgenisRoleGroupLink>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			MolgenisRoleGroupLink object = new MolgenisRoleGroupLink();
			object.set(tuple, false);				
			molgenisRoleGroupLinkList.add(object);		
			
			//add to db when batch size is reached
			if(molgenisRoleGroupLinkList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				molgenisRoleGroupLinksMissingRefs.addAll(resolveForeignKeys(db, molgenisRoleGroupLinkList));
				molgenisRoleGroupLinkList.removeAll(molgenisRoleGroupLinksMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(molgenisRoleGroupLinkList,dbAction, "Identifier");
				
				//clear for next batch						
				molgenisRoleGroupLinkList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!molgenisRoleGroupLinkList.isEmpty())
		{
			total.set(total.get() + molgenisRoleGroupLinkList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			molgenisRoleGroupLinksMissingRefs.addAll(resolveForeignKeys(db, molgenisRoleGroupLinkList));
			molgenisRoleGroupLinkList.removeAll(molgenisRoleGroupLinksMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(molgenisRoleGroupLinkList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MolgenisRoleGroupLink> molgenisRoleGroupLinks = new ArrayList<MolgenisRoleGroupLink>(molgenisRoleGroupLinksMissingRefs);

		int iterationCount = 0;

		do
		{
			molgenisRoleGroupLinksMissingRefs = resolveForeignKeys(db, molgenisRoleGroupLinksMissingRefs);
			
			LinkedHashSet<MolgenisRoleGroupLink> differenceSet = new LinkedHashSet<MolgenisRoleGroupLink>();
			Sets.symmetricDifference(new LinkedHashSet<MolgenisRoleGroupLink>(molgenisRoleGroupLinks), new LinkedHashSet<MolgenisRoleGroupLink>(molgenisRoleGroupLinksMissingRefs)).copyInto(differenceSet);
			List<MolgenisRoleGroupLink> resolvablemolgenisRoleGroupLinks = new ArrayList<MolgenisRoleGroupLink>(differenceSet);
			
			molgenisRoleGroupLinks.removeAll(resolvablemolgenisRoleGroupLinks);
			
			db.update(resolvablemolgenisRoleGroupLinks,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MolgenisRoleGroupLink blaat : molgenisRoleGroupLinksMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'molgenisRoleGroupLink' entity failed:"
								+ "This is probably caused by a(n) 'molgenisRoleGroupLink' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (molgenisRoleGroupLinksMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " molgenisRoleGroupLink from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param molgenisRoleGroupLinkList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MolgenisRoleGroupLink> resolveForeignKeys(Database db, List<MolgenisRoleGroupLink> molgenisRoleGroupLinkList) throws Exception
	{
		//keep a list of MolgenisRoleGroupLink instances that miss a reference which might be resolvable later
		List<MolgenisRoleGroupLink> molgenisRoleGroupLinksMissingRefs = new ArrayList<MolgenisRoleGroupLink>();
	
		//resolve xref 'group_' from molgenisGroup.Name -> molgenisGroup.id
		for(MolgenisRoleGroupLink o: molgenisRoleGroupLinkList) 
		{
			if(o.getGroup_Name() != null) 
				group_Keymap.put(o.getGroup_Name(), null);
		}
		
		if(group_Keymap.size() > 0) 
		{
			List<MolgenisGroup> group_List = db.query(MolgenisGroup.class).in("Name",new ArrayList<Object>(group_Keymap.keySet())).find();
			for(MolgenisGroup xref :  group_List)
			{
				group_Keymap.put(xref.getName(), xref.getId());
			}
		}
		//resolve xref 'role_' from molgenisRole.Name -> molgenisRole.id
		for(MolgenisRoleGroupLink o: molgenisRoleGroupLinkList) 
		{
			if(o.getRole_Name() != null) 
				role_Keymap.put(o.getRole_Name(), null);
		}
		
		if(role_Keymap.size() > 0) 
		{
			List<MolgenisRole> role_List = db.query(MolgenisRole.class).in("Name",new ArrayList<Object>(role_Keymap.keySet())).find();
			for(MolgenisRole xref :  role_List)
			{
				role_Keymap.put(xref.getName(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(MolgenisRoleGroupLink o:  molgenisRoleGroupLinkList)
		{
			while(true){
				//update xref group_
				if(o.getGroup_Name() != null) 
				{
					String key = o.getGroup_Name();
					if(group_Keymap.get(key) == null)
					{
						throw new Exception("Import of 'MolgenisRoleGroupLink' objects failed: cannot find MolgenisGroup for group__Name='"+o.getGroup_Name()+"'");
					}
					o.setGroup_Id(group_Keymap.get(key));
				}
				//update xref role_
				if(o.getRole_Name() != null) 
				{
					String key = o.getRole_Name();
					if(role_Keymap.get(key) == null)
					{
						throw new Exception("Import of 'MolgenisRoleGroupLink' objects failed: cannot find MolgenisRole for role__Name='"+o.getRole_Name()+"'");
					}
					o.setRole_Id(role_Keymap.get(key));
				}
				break;
			}
		}
		
		group_Keymap.clear();
		role_Keymap.clear();
		
		return molgenisRoleGroupLinksMissingRefs;
	}
}

