/* File:        org.molgenis.omx/model/MolgenisUser.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        August 21, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class MolgenisUserJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.auth.MolgenisUser>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(MolgenisUserJpaMapper.class);

	public MolgenisUserJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT MolgenisUser.id"
			+", MolgenisRole.Identifier"
			+", MolgenisRole.Name"
			+", MolgenisRole.__Type"
			+", MolgenisUser.Address"
			+", MolgenisUser.Phone"
			+", MolgenisUser.Email"
			+", MolgenisUser.Fax"
			+", MolgenisUser.tollFreePhone"
			+", MolgenisUser.City"
			+", MolgenisUser.Country"
			+", MolgenisUser.FirstName"
			+", MolgenisUser.MidInitials"
			+", MolgenisUser.LastName"
			+", MolgenisUser.Title"
			+", MolgenisUser.Affiliation"
			+", MolgenisUser.Department"
			+", MolgenisUser.Roles"
			+", MolgenisUser.password_"
			+", MolgenisUser.activationCode"
			+", MolgenisUser.active"
			+", MolgenisUser.superuser"
			//parent is SimpleTree(name='Affiliation')
			+", xref_Affiliation.Name AS Affiliation_Name"
			//parent is SimpleTree(name='Roles')
			+", xref_Roles.Identifier AS Roles_Identifier"
			+" FROM MolgenisUser "
			+" INNER JOIN MolgenisRole ON (MolgenisUser.id = MolgenisRole.id)"

			
			//label for Affiliation=Name
//path==Affiliation. type==xref.
//path==Affiliation_Name. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Institute AS xref_Affiliation " 
			+" ON xref_Affiliation.id = MolgenisUser.Affiliation"
			
			//label for Roles=Identifier
//path==Roles. type==xref.
//path==Roles_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Roles " 
			+" ON xref_Roles.id = MolgenisUser.Roles"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.auth.MolgenisUser entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Affiliation' is known in the databse
			if(entity.getAffiliation() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getAffiliation().getIdValue() == null)
					new org.molgenis.omx.auth.db.InstituteJpaMapper(getDatabase()).create(entity.getAffiliation());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getAffiliation()) && entity.getAffiliation().getIdValue() != null)
					entity.setAffiliation(getEntityManager().getReference(org.molgenis.omx.auth.Institute.class, entity.getAffiliation().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getAffiliation_Id() != null) {
					entity.setAffiliation((org.molgenis.omx.auth.Institute)getEntityManager().find(org.molgenis.omx.auth.Institute.class, entity.getAffiliation_Id()));
				}
			}
			//check if the object refered by 'Roles' is known in the databse
			if(entity.getRoles() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getRoles().getIdValue() == null)
					new org.molgenis.omx.auth.db.PersonRoleJpaMapper(getDatabase()).create(entity.getRoles());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getRoles()) && entity.getRoles().getIdValue() != null)
					entity.setRoles(getEntityManager().getReference(org.molgenis.omx.auth.PersonRole.class, entity.getRoles().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getRoles_Id() != null) {
					entity.setRoles((org.molgenis.omx.auth.PersonRole)getEntityManager().find(org.molgenis.omx.auth.PersonRole.class, entity.getRoles_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.auth.MolgenisUser molgenisUser) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				molgenisUser = getEntityManager().getReference(org.molgenis.omx.auth.MolgenisUser.class, molgenisUser.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The molgenisUser with id " + molgenisUser.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(molgenisUser);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.auth.MolgenisUser molgenisUser) throws org.molgenis.framework.db.DatabaseException {
		try {

















			//3
			org.molgenis.omx.auth.Institute affiliationNew = molgenisUser.getAffiliation();

			if (affiliationNew == null) { //object is reference by xref		
                            if(molgenisUser.getAffiliation_Id() != null) {
                                molgenisUser.setAffiliation((org.molgenis.omx.auth.Institute)getEntityManager().find(org.molgenis.omx.auth.Institute.class, molgenisUser.getAffiliation_Id()));
                            }
			}



			//3
			org.molgenis.omx.auth.PersonRole rolesNew = molgenisUser.getRoles();

			if (rolesNew == null) { //object is reference by xref		
                            if(molgenisUser.getRoles_Id() != null) {
                                molgenisUser.setRoles((org.molgenis.omx.auth.PersonRole)getEntityManager().find(org.molgenis.omx.auth.PersonRole.class, molgenisUser.getRoles_Id()));
                            }
			}




			if(!getEntityManager().contains(molgenisUser)) {
				molgenisUser = getEntityManager().merge(molgenisUser);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.auth.MolgenisUser> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.auth.MolgenisUser molgenisUser : entities) 
			{
				create(molgenisUser);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.auth.MolgenisUser> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.auth.MolgenisUser molgenisUser : entities) 
			{
				edit(molgenisUser);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.auth.MolgenisUser> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.auth.MolgenisUser molgenisUser : entities) 
			{
				destroy(molgenisUser);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("MolgenisUser_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("MolgenisUser_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("MolgenisUser_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("MolgenisUser___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Address".equalsIgnoreCase(fieldName)) return "Address";
		if("MolgenisUser_Address".equalsIgnoreCase(fieldName)) return "Address";
		if("Phone".equalsIgnoreCase(fieldName)) return "Phone";
		if("MolgenisUser_Phone".equalsIgnoreCase(fieldName)) return "Phone";
		if("Email".equalsIgnoreCase(fieldName)) return "Email";
		if("MolgenisUser_Email".equalsIgnoreCase(fieldName)) return "Email";
		if("Fax".equalsIgnoreCase(fieldName)) return "Fax";
		if("MolgenisUser_Fax".equalsIgnoreCase(fieldName)) return "Fax";
		if("tollFreePhone".equalsIgnoreCase(fieldName)) return "tollFreePhone";
		if("MolgenisUser_tollFreePhone".equalsIgnoreCase(fieldName)) return "tollFreePhone";
		if("City".equalsIgnoreCase(fieldName)) return "City";
		if("MolgenisUser_City".equalsIgnoreCase(fieldName)) return "City";
		if("Country".equalsIgnoreCase(fieldName)) return "Country";
		if("MolgenisUser_Country".equalsIgnoreCase(fieldName)) return "Country";
		if("FirstName".equalsIgnoreCase(fieldName)) return "FirstName";
		if("MolgenisUser_FirstName".equalsIgnoreCase(fieldName)) return "FirstName";
		if("MidInitials".equalsIgnoreCase(fieldName)) return "MidInitials";
		if("MolgenisUser_MidInitials".equalsIgnoreCase(fieldName)) return "MidInitials";
		if("LastName".equalsIgnoreCase(fieldName)) return "LastName";
		if("MolgenisUser_LastName".equalsIgnoreCase(fieldName)) return "LastName";
		if("Title".equalsIgnoreCase(fieldName)) return "Title";
		if("MolgenisUser_Title".equalsIgnoreCase(fieldName)) return "Title";
		if("Affiliation".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("MolgenisUser_Affiliation".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Department".equalsIgnoreCase(fieldName)) return "Department";
		if("MolgenisUser_Department".equalsIgnoreCase(fieldName)) return "Department";
		if("Roles".equalsIgnoreCase(fieldName)) return "Roles";
		if("MolgenisUser_Roles".equalsIgnoreCase(fieldName)) return "Roles";
		if("password_".equalsIgnoreCase(fieldName)) return "password_";
		if("MolgenisUser_password_".equalsIgnoreCase(fieldName)) return "password_";
		if("activationCode".equalsIgnoreCase(fieldName)) return "activationCode";
		if("MolgenisUser_activationCode".equalsIgnoreCase(fieldName)) return "activationCode";
		if("active".equalsIgnoreCase(fieldName)) return "active";
		if("MolgenisUser_active".equalsIgnoreCase(fieldName)) return "active";
		if("superuser".equalsIgnoreCase(fieldName)) return "superuser";
		if("MolgenisUser_superuser".equalsIgnoreCase(fieldName)) return "superuser";
		if("Affiliation_id".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("MolgenisUser_Affiliation_id".equalsIgnoreCase(fieldName)) return "Affiliation";
		if("Affiliation_Name".equalsIgnoreCase(fieldName)) return "Affiliation.Name";	
		if("MolgenisUser_Affiliation_Name".equalsIgnoreCase(fieldName)) return "Affiliation.Name";
		if("Roles_id".equalsIgnoreCase(fieldName)) return "Roles";
		if("MolgenisUser_Roles_id".equalsIgnoreCase(fieldName)) return "Roles";
		if("Roles_Identifier".equalsIgnoreCase(fieldName)) return "Roles.Identifier";	
		if("MolgenisUser_Roles_Identifier".equalsIgnoreCase(fieldName)) return "Roles.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.auth.MolgenisUser> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.auth.MolgenisUser>(size);
	}			

	@Override
	public org.molgenis.omx.auth.MolgenisUser create()
	{
		return new org.molgenis.omx.auth.MolgenisUser();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.auth.MolgenisUser> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'affiliation' to institute.id using Name)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> affiliationRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'roles' to personRole.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> rolesRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.auth.MolgenisUser object: entities)
		{
			//create xref/mref rule filtering Institute on the label Name
			if(object.getAffiliation_Id() == null && object.getAffiliation_Name() != null)
			{
				Object label = object.getAffiliation_Name();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Name", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !affiliationRules.containsKey(label))
					{
						affiliationRules.put(""+label, xrefFilter);
						affiliationRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering PersonRole on the label Identifier
			if(object.getRoles_Id() == null && object.getRoles_Identifier() != null)
			{
				Object label = object.getRoles_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(label != null && !rolesRules.containsKey(label))
					{
						rolesRules.put(""+label, xrefFilter);
						rolesRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'affiliation' to institute.id using Name)
		final java.util.Map<String,Integer> affiliation_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(affiliationRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.auth.Institute> affiliationList = null;
			try
			{
				affiliationList = getDatabase().find(org.molgenis.omx.auth.Institute.class, affiliationRules.values().toArray(new org.molgenis.framework.db.QueryRule[affiliationRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.auth.Institute xref :  affiliationList)
			{
				String key = "";
				key += 	xref.getName();
				
				affiliation_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'roles' to personRole.id using Identifier)
		final java.util.Map<String,Integer> roles_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(rolesRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.auth.PersonRole> rolesList = null;
			try
			{
				rolesList = getDatabase().find(org.molgenis.omx.auth.PersonRole.class, rolesRules.values().toArray(new org.molgenis.framework.db.QueryRule[rolesRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.auth.PersonRole xref :  rolesList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				roles_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.auth.MolgenisUser object = entities.get(i);		
			//update object using label fields Name
			if(object.getAffiliation_Id() == null )
			{
					String key = "";
					if(object.getAffiliation_Name() != null)
						key += 	object.getAffiliation_Name();
					
					if(!"".equals(key) && affiliation_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Affiliation_Name cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setAffiliation_Id(affiliation_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getRoles_Id() == null )
			{
					String key = "";
					if(object.getRoles_Identifier() != null)
						key += 	object.getRoles_Identifier();
					
					if(!"".equals(key) && roles_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Roles_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setRoles_Id(roles_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "molgenisUser.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "molgenisRole.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "molgenisRole.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "molgenisRole.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("address".equalsIgnoreCase(fieldName) || "molgenisUser.address".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("phone".equalsIgnoreCase(fieldName) || "molgenisUser.phone".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("email".equalsIgnoreCase(fieldName) || "molgenisUser.email".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("fax".equalsIgnoreCase(fieldName) || "molgenisUser.fax".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("tollFreePhone".equalsIgnoreCase(fieldName) || "molgenisUser.tollFreePhone".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("city".equalsIgnoreCase(fieldName) || "molgenisUser.city".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("country".equalsIgnoreCase(fieldName) || "molgenisUser.country".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("firstName".equalsIgnoreCase(fieldName) || "molgenisUser.firstName".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("midInitials".equalsIgnoreCase(fieldName) || "molgenisUser.midInitials".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("lastName".equalsIgnoreCase(fieldName) || "molgenisUser.lastName".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("title".equalsIgnoreCase(fieldName) || "molgenisUser.title".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("affiliation".equalsIgnoreCase(fieldName) || "molgenisUser.affiliation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("department".equalsIgnoreCase(fieldName) || "molgenisUser.department".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("roles".equalsIgnoreCase(fieldName) || "molgenisUser.roles".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("password_".equalsIgnoreCase(fieldName) || "molgenisUser.password_".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("activationCode".equalsIgnoreCase(fieldName) || "molgenisUser.activationCode".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("active".equalsIgnoreCase(fieldName) || "molgenisUser.active".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("superuser".equalsIgnoreCase(fieldName) || "molgenisUser.superuser".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.auth.MolgenisUser> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.auth.MolgenisUser> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
