package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.HyperlinkValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class HyperlinkValueService
{
	private static final Logger logger = Logger.getLogger(HyperlinkValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public HyperlinkValue create(HyperlinkValue hyperlinkValue) throws DatabaseException
	{
		logger.debug("creating HyperlinkValue");
		db.add(hyperlinkValue);
		return hyperlinkValue;
	}

	public HyperlinkValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving HyperlinkValue");
		return db.findById(HyperlinkValue.class, id);
	}

	public void update(HyperlinkValue hyperlinkValue) throws DatabaseException
	{
		logger.debug("updating HyperlinkValue");
		db.update(hyperlinkValue);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting HyperlinkValue");
		HyperlinkValue hyperlinkValue = db.findById(HyperlinkValue.class, id);
		return db.remove(hyperlinkValue) == 1;
	}
	
	public Iterable<HyperlinkValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all HyperlinkValue instances");
		return db.find(HyperlinkValue.class);
	}
	
	public EntityPager<HyperlinkValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all HyperlinkValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(HyperlinkValue.class, queryRules.toArray(new QueryRule[0]));
		List<HyperlinkValue> hyperlinkValueCollection = db.find(HyperlinkValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<HyperlinkValue>(start, num, count, hyperlinkValueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("HyperlinkValue");
	}
}