
/* File:        org.molgenis.omx/model/MolgenisGroup.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisGroup;


/**
 * Reads MolgenisGroup from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MolgenisGroupEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MolgenisGroupEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports MolgenisGroup from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MolgenisGroup> molgenisGroupsMissingRefs = new ArrayList<MolgenisGroup>();
	
		//cache for objects to be imported from file (in batch)
		final List<MolgenisGroup> molgenisGroupList = new ArrayList<MolgenisGroup>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			MolgenisGroup object = new MolgenisGroup();
			object.set(tuple, false);				
			molgenisGroupList.add(object);		
			
			//add to db when batch size is reached
			if(molgenisGroupList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				molgenisGroupsMissingRefs.addAll(resolveForeignKeys(db, molgenisGroupList));
				molgenisGroupList.removeAll(molgenisGroupsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
				db.update(molgenisGroupList,dbAction, "Name");
				
				//clear for next batch						
				molgenisGroupList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!molgenisGroupList.isEmpty())
		{
			total.set(total.get() + molgenisGroupList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			molgenisGroupsMissingRefs.addAll(resolveForeignKeys(db, molgenisGroupList));
			molgenisGroupList.removeAll(molgenisGroupsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
			db.update(molgenisGroupList,dbAction, "Name");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MolgenisGroup> molgenisGroups = new ArrayList<MolgenisGroup>(molgenisGroupsMissingRefs);

		int iterationCount = 0;

		do
		{
			molgenisGroupsMissingRefs = resolveForeignKeys(db, molgenisGroupsMissingRefs);
			
			LinkedHashSet<MolgenisGroup> differenceSet = new LinkedHashSet<MolgenisGroup>();
			Sets.symmetricDifference(new LinkedHashSet<MolgenisGroup>(molgenisGroups), new LinkedHashSet<MolgenisGroup>(molgenisGroupsMissingRefs)).copyInto(differenceSet);
			List<MolgenisGroup> resolvablemolgenisGroups = new ArrayList<MolgenisGroup>(differenceSet);
			
			molgenisGroups.removeAll(resolvablemolgenisGroups);
			
			db.update(resolvablemolgenisGroups,dbAction, "Name");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MolgenisGroup blaat : molgenisGroupsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'molgenisGroup' entity failed:"
								+ "This is probably caused by a(n) 'molgenisGroup' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (molgenisGroupsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " molgenisGroup from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param molgenisGroupList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MolgenisGroup> resolveForeignKeys(Database db, List<MolgenisGroup> molgenisGroupList) throws Exception
	{
		//keep a list of MolgenisGroup instances that miss a reference which might be resolvable later
		List<MolgenisGroup> molgenisGroupsMissingRefs = new ArrayList<MolgenisGroup>();
	
		//update objects with foreign key values
		for(MolgenisGroup o:  molgenisGroupList)
		{
			while(true){
				break;
			}
		}
		
		
		return molgenisGroupsMissingRefs;
	}
}

