
/* File:        org.molgenis.omx/model/MolgenisRole.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisRole;


/**
 * Reads MolgenisRole from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MolgenisRoleEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MolgenisRoleEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports MolgenisRole from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MolgenisRole> molgenisRolesMissingRefs = new ArrayList<MolgenisRole>();
	
		//cache for objects to be imported from file (in batch)
		final List<MolgenisRole> molgenisRoleList = new ArrayList<MolgenisRole>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			MolgenisRole object = new MolgenisRole();
			object.set(tuple, false);				
			molgenisRoleList.add(object);		
			
			//add to db when batch size is reached
			if(molgenisRoleList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				molgenisRolesMissingRefs.addAll(resolveForeignKeys(db, molgenisRoleList));
				molgenisRoleList.removeAll(molgenisRolesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
				db.update(molgenisRoleList,dbAction, "Name");
				
				//clear for next batch						
				molgenisRoleList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!molgenisRoleList.isEmpty())
		{
			total.set(total.get() + molgenisRoleList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			molgenisRolesMissingRefs.addAll(resolveForeignKeys(db, molgenisRoleList));
			molgenisRoleList.removeAll(molgenisRolesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Name' defined in xref_label
			db.update(molgenisRoleList,dbAction, "Name");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MolgenisRole> molgenisRoles = new ArrayList<MolgenisRole>(molgenisRolesMissingRefs);

		int iterationCount = 0;

		do
		{
			molgenisRolesMissingRefs = resolveForeignKeys(db, molgenisRolesMissingRefs);
			
			LinkedHashSet<MolgenisRole> differenceSet = new LinkedHashSet<MolgenisRole>();
			Sets.symmetricDifference(new LinkedHashSet<MolgenisRole>(molgenisRoles), new LinkedHashSet<MolgenisRole>(molgenisRolesMissingRefs)).copyInto(differenceSet);
			List<MolgenisRole> resolvablemolgenisRoles = new ArrayList<MolgenisRole>(differenceSet);
			
			molgenisRoles.removeAll(resolvablemolgenisRoles);
			
			db.update(resolvablemolgenisRoles,dbAction, "Name");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MolgenisRole blaat : molgenisRolesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'molgenisRole' entity failed:"
								+ "This is probably caused by a(n) 'molgenisRole' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (molgenisRolesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " molgenisRole from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param molgenisRoleList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MolgenisRole> resolveForeignKeys(Database db, List<MolgenisRole> molgenisRoleList) throws Exception
	{
		//keep a list of MolgenisRole instances that miss a reference which might be resolvable later
		List<MolgenisRole> molgenisRolesMissingRefs = new ArrayList<MolgenisRole>();
	
		//update objects with foreign key values
		for(MolgenisRole o:  molgenisRoleList)
		{
			while(true){
				break;
			}
		}
		
		
		return molgenisRolesMissingRefs;
	}
}

