package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.Person;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PersonService
{
	private static final Logger logger = Logger.getLogger(PersonService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Person create(Person person) throws DatabaseException
	{
		logger.debug("creating Person");
		db.add(person);
		return person;
	}

	public Person read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Person");
		return db.findById(Person.class, id);
	}

	public void update(Person person) throws DatabaseException
	{
		logger.debug("updating Person");
		db.update(person);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Person");
		Person person = db.findById(Person.class, id);
		return db.remove(person) == 1;
	}
	
	public Iterable<Person> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Person instances");
		return db.find(Person.class);
	}
	
	public EntityPager<Person> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Person instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Person.class, queryRules.toArray(new QueryRule[0]));
		List<Person> personCollection = db.find(Person.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Person>(start, num, count, personCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Person");
	}
}