package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.core.RuntimeProperty;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class RuntimePropertyService
{
	private static final Logger logger = Logger.getLogger(RuntimePropertyService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public RuntimeProperty create(RuntimeProperty runtimeProperty) throws DatabaseException
	{
		logger.debug("creating RuntimeProperty");
		db.add(runtimeProperty);
		return runtimeProperty;
	}

	public RuntimeProperty read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving RuntimeProperty");
		return db.findById(RuntimeProperty.class, id);
	}

	public void update(RuntimeProperty runtimeProperty) throws DatabaseException
	{
		logger.debug("updating RuntimeProperty");
		db.update(runtimeProperty);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting RuntimeProperty");
		RuntimeProperty runtimeProperty = db.findById(RuntimeProperty.class, id);
		return db.remove(runtimeProperty) == 1;
	}
	
	public Iterable<RuntimeProperty> readAll() throws DatabaseException
	{
		logger.debug("retrieving all RuntimeProperty instances");
		return db.find(RuntimeProperty.class);
	}
	
	public EntityPager<RuntimeProperty> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all RuntimeProperty instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(RuntimeProperty.class, queryRules.toArray(new QueryRule[0]));
		List<RuntimeProperty> runtimePropertyCollection = db.find(RuntimeProperty.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<RuntimeProperty>(start, num, count, runtimePropertyCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("RuntimeProperty");
	}
}