/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.mappingmanager;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.io.csv.CsvWriter;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.util.GsonHttpMessageConverter;
import org.molgenis.util.tuple.Tuple;
import org.molgenis.util.tuple.ValueTuple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/mappingmanager"})
public class MappingManagerController
extends MolgenisPluginController {
    private static final Logger logger = Logger.getLogger(MappingManagerController.class);
    public static final String ID = "mappingmanager";
    public static final String URI = "/plugin/mappingmanager";
    private static final String FEATURE_ID = "id";
    private static final String FEATURE_NAME = "name";
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    private static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    private static final String STORE_MAPPING_MAPPED_FEATURE = "store_mapping_mapped_feature";
    private static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    private final OntologyMatcher ontologyMatcher;
    private final SearchService searchService;
    private final Database database;

    @Autowired
    public MappingManagerController(OntologyMatcher ontologyMatcher, SearchService searchService, Database database) {
        super(URI);
        if (ontologyMatcher == null) {
            throw new IllegalArgumentException("OntologyMatcher is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Database is null");
        }
        this.ontologyMatcher = ontologyMatcher;
        this.searchService = searchService;
        this.database = database;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(@RequestParam(value="selectedDataSet", required=false) String selectedDataSetId, Model model) throws DatabaseException {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (DataSet dataSet : this.database.find(DataSet.class, new QueryRule[0])) {
            if (dataSet.getProtocolUsed_Identifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        model.addAttribute("dataSets", dataSets);
        if (selectedDataSetId != null) {
            model.addAttribute("selectedDataSet", (Object)selectedDataSetId);
        }
        model.addAttribute("isRunning", (Object)this.ontologyMatcher.isRunning());
        return "MappingManagerPlugin";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delete"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDocuments(@RequestBody UpdateIndexRequest request) {
        try {
            this.searchService.deleteDocumentByIds(request.getDocumentType(), request.getDocumentIds());
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/update"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDocument(@RequestBody UpdateIndexRequest request) {
        try {
            this.searchService.updateDocumentById(request.getDocumentType(), request.getDocumentIds().get(0), request.getUpdateScript());
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public void download(@RequestParam(value="request") String requestString, HttpServletResponse response) throws IOException, DatabaseException, TableException {
        requestString = URLDecoder.decode(requestString, "UTF-8");
        logger.info((Object)("Download request: [" + requestString + "]"));
        UpdateIndexRequest request = (UpdateIndexRequest)new GsonHttpMessageConverter().getGson().fromJson(requestString, UpdateIndexRequest.class);
        response.setContentType("text/csv");
        response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName(request.getDocumentType()));
        CsvWriter tupleWriter = null;
        try {
            HashSet<Integer> featureIds = new HashSet<Integer>();
            tupleWriter = new CsvWriter((Writer)response.getWriter());
            Integer dataSetId = request.getDataSetId();
            DataSet mappingDataSet = (DataSet)this.database.findById(DataSet.class, (Object)dataSetId);
            List storeMappingDataSet = this.database.find(DataSet.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.LIKE, "" + dataSetId)});
            ArrayList<String> dataSetNames = new ArrayList<String>();
            dataSetNames.add(mappingDataSet.getName());
            HashMap dataSetMappings = new HashMap();
            for (DataSet dataSet : storeMappingDataSet) {
                Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[1]);
                if (mappedDataSetId.equals(dataSetId)) continue;
                DataSet mappedDataSet = (DataSet)this.database.findById(DataSet.class, (Object)mappedDataSetId);
                dataSetNames.add(mappedDataSet.getName());
                ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                rules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)1000000));
                SearchRequest searchRequest = new SearchRequest(dataSet.getIdentifier(), rules, null);
                SearchResult result = this.searchService.search(searchRequest);
                HashMap<Integer, MappingClass> storeMappings = new HashMap<Integer, MappingClass>();
                for (Hit hit : result.getSearchHits()) {
                    Map map = hit.getColumnValueMap();
                    Integer storeMappingFeatureId = Integer.parseInt(map.get(STORE_MAPPING_FEATURE).toString());
                    Integer storeMappingMappedFeatureId = Integer.parseInt(map.get(STORE_MAPPING_MAPPED_FEATURE).toString());
                    boolean confirmation = (Boolean)map.get(STORE_MAPPING_CONFIRM_MAPPING);
                    if (!storeMappings.containsKey(storeMappingFeatureId)) {
                        storeMappings.put(storeMappingFeatureId, new MappingClass());
                    }
                    ((MappingClass)storeMappings.get(storeMappingFeatureId)).addMapping(storeMappingFeatureId, storeMappingMappedFeatureId, confirmation);
                    featureIds.add(storeMappingFeatureId);
                    featureIds.add(storeMappingMappedFeatureId);
                }
                dataSetMappings.put(mappedDataSetId, storeMappings);
            }
            HashMap<Integer, ObservableFeature> featureMap = new HashMap<Integer, ObservableFeature>();
            for (ObservableFeature feature : this.database.find(ObservableFeature.class, new QueryRule[]{new QueryRule(FEATURE_ID, QueryRule.Operator.IN, new ArrayList(featureIds))})) {
                featureMap.put(feature.getId(), feature);
            }
            tupleWriter.write((Tuple)new ValueTuple(dataSetNames));
            ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
            rules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)1000000));
            SearchRequest searchFeatures = new SearchRequest("protocolTree-" + dataSetId, rules, null);
            SearchResult featureSearchResult = this.searchService.search(searchFeatures);
            for (Hit hit : featureSearchResult.getSearchHits()) {
                ArrayList<String> values = new ArrayList<String>();
                Map map = hit.getColumnValueMap();
                String featureName = map.get(FEATURE_NAME).toString();
                Integer featureId = Integer.parseInt(map.get(FEATURE_ID).toString());
                values.add(featureName);
                for (DataSet dataSet : storeMappingDataSet) {
                    Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[1]);
                    if (mappedDataSetId.equals(dataSetId)) continue;
                    StringBuilder value = new StringBuilder();
                    Map storeMappings = (Map)dataSetMappings.get(mappedDataSetId);
                    if (storeMappings.containsKey(featureId)) {
                        List<Integer> candidateIds = null;
                        MappingClass mappingClass = (MappingClass)storeMappings.get(featureId);
                        candidateIds = mappingClass.isConfirmation() ? mappingClass.getFinalizedMapping() : mappingClass.getCandidateMappings();
                        for (Integer id : candidateIds) {
                            if (!featureMap.containsKey(id)) continue;
                            value.append(((ObservableFeature)featureMap.get(id)).getName());
                            value.append(',');
                        }
                    }
                    values.add(value.toString());
                }
                tupleWriter.write((Tuple)new ValueTuple(values));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(tupleWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)tupleWriter);
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".csv";
    }

    static class MappingClass {
        private Integer featureId = null;
        private boolean confirmation = false;
        private List<Integer> finalizedMapping = null;
        private List<Integer> candidateMappings = null;

        MappingClass() {
        }

        public void addMapping(Integer featureId, Integer singleMappedFeatureId, boolean confirmation) {
            if (this.featureId == null) {
                this.featureId = featureId;
            }
            if (this.finalizedMapping == null) {
                this.finalizedMapping = new ArrayList<Integer>();
            }
            if (this.candidateMappings == null) {
                this.candidateMappings = new ArrayList<Integer>();
            }
            this.confirmation = confirmation;
            this.candidateMappings.add(singleMappedFeatureId);
            if (confirmation) {
                this.finalizedMapping.add(singleMappedFeatureId);
            }
        }

        public Integer getFeatureId() {
            return this.featureId;
        }

        public boolean isConfirmation() {
            return this.confirmation;
        }

        public List<Integer> getFinalizedMapping() {
            return this.finalizedMapping;
        }

        public List<Integer> getCandidateMappings() {
            return this.candidateMappings;
        }
    }
}

