/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyannotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.omx.biobankconnect.ontologyannotator.OntologyAnnotator;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.tartarus.snowball.ext.PorterStemmer;

public class AsyncOntologyAnnotator
implements OntologyAnnotator,
InitializingBean {
    @Autowired
    private Database database;
    private SearchService searchService;
    private static final AtomicInteger runningProcesses = new AtomicInteger();
    private static final Logger logger = Logger.getLogger(AsyncOntologyAnnotator.class);
    private static boolean complete = false;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isRunning() {
        return runningProcesses.get() != 0;
    }

    @Override
    public boolean isComplete() {
        return complete;
    }

    @Override
    public void initComplete() {
        complete = false;
    }

    @Override
    public void removeAnnotations(Integer dataSetId) {
        try {
            DataSet dataSet = (DataSet)this.database.findById(DataSet.class, (Object)dataSetId);
            ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
            queryRules.add(new QueryRule("type", QueryRule.Operator.SEARCH, "observablefeature"));
            queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)100000));
            SearchRequest request = new SearchRequest("protocolTree-" + dataSet.getId(), queryRules, null);
            SearchResult result = this.searchService.search(request);
            ArrayList<Integer> listOfFeatureIds = new ArrayList<Integer>();
            for (Hit hit : result) {
                Map columnMapValues = hit.getColumnValueMap();
                Integer featureId = Integer.parseInt(columnMapValues.get("id").toString());
                listOfFeatureIds.add(featureId);
            }
            ArrayList<ObservableFeature> featuresToUpdate = new ArrayList<ObservableFeature>();
            for (ObservableFeature feature : this.database.find(ObservableFeature.class, new QueryRule[]{new QueryRule("id", QueryRule.Operator.IN, listOfFeatureIds)})) {
                List definitions = feature.getDefinitions();
                if (definitions == null || definitions.size() <= 0) continue;
                ObservableFeature newFeature = this.copyObject(feature);
                newFeature.setDefinitions_Identifier(new ArrayList());
                featuresToUpdate.add(newFeature);
            }
            this.database.update(featuresToUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObservableFeature copyObject(ObservableFeature feature) throws Exception {
        ObservableFeature newFeature = new ObservableFeature();
        for (String field : feature.getFields()) {
            newFeature.set(field, feature.get(field));
        }
        return newFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotate(Integer dataSetId, List<String> documentTypes) {
        runningProcesses.incrementAndGet();
        try {
            if (documentTypes == null) {
                documentTypes = this.searchAllOntologies();
            }
            PorterStemmer stemmer = new PorterStemmer();
            ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
            queryRules.add(new QueryRule("type", QueryRule.Operator.SEARCH, "observablefeature"));
            queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)100000));
            SearchRequest request = new SearchRequest("protocolTree-" + dataSetId, queryRules, null);
            SearchResult result = this.searchService.search(request);
            ArrayList<ObservableFeature> featuresToUpdate = new ArrayList<ObservableFeature>();
            for (Hit hit : result) {
                Integer featureId = Integer.parseInt(hit.getColumnValueMap().get("id").toString());
                ObservableFeature feature = this.toObservableFeature((ObservableFeature)this.database.findById(ObservableFeature.class, (Object)featureId));
                String name = hit.getColumnValueMap().get("name").toString().toLowerCase().replaceAll("[^(a-zA-Z0-9\\s)]", "").trim();
                String description = hit.getColumnValueMap().get("description").toString().toLowerCase().replaceAll("[^(a-zA-Z0-9\\s)]", "").trim();
                ArrayList<String> definitions = new ArrayList<String>();
                for (String documentType : documentTypes) {
                    definitions.addAll(this.annotateDataItem(this.database, documentType, feature, name, stemmer));
                    definitions.addAll(this.annotateDataItem(this.database, documentType, feature, description, stemmer));
                }
                if (definitions.size() > 0) {
                    definitions.addAll(feature.getDefinitions_Identifier());
                    feature.setDefinitions_Identifier(definitions);
                }
                featuresToUpdate.add(feature);
            }
            this.database.update(featuresToUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            runningProcesses.decrementAndGet();
            complete = true;
        }
    }

    public List<String> searchAllOntologies() {
        ArrayList<String> ontologyUris = new ArrayList<String>();
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        queryRules.add(new QueryRule("entity_type", QueryRule.Operator.SEARCH, "indexedOntology"));
        queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)100000));
        SearchResult result = this.searchService.search(new SearchRequest(null, queryRules, null));
        for (Hit hit : result.getSearchHits()) {
            Map columnValueMap = hit.getColumnValueMap();
            if (!columnValueMap.containsKey("url")) continue;
            ontologyUris.add("ontologyTerm-" + columnValueMap.get("url").toString());
        }
        return ontologyUris;
    }

    @Override
    public void updateIndex(UpdateIndexRequest request) {
        try {
            for (String documentId : request.getDocumentIds()) {
                this.searchService.updateDocumentById(request.getDocumentType(), documentId, request.getUpdateScript());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    private ObservableFeature toObservableFeature(ObservableFeature feature) throws Exception {
        ObservableFeature newFeature = new ObservableFeature();
        for (String field : feature.getFields()) {
            newFeature.set(field, feature.get(field));
        }
        return newFeature;
    }

    public List<String> annotateDataItem(Database db, String documentType, ObservableFeature feature, String description, PorterStemmer stemmer) throws DatabaseException {
        HashSet<String> uniqueTerms = new HashSet<String>();
        for (String eachTerm : Arrays.asList(description.split(" +"))) {
            if (NGramMatchingModel.STOPWORDSLIST.contains(eachTerm = eachTerm.toLowerCase()) || uniqueTerms.contains(eachTerm)) continue;
            uniqueTerms.add(eachTerm);
        }
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)100));
        for (String term : uniqueTerms) {
            if (term.isEmpty() || term.matches(" +")) continue;
            term = term.replaceAll("[^(a-zA-Z0-9 )]", "");
            queryRules.add(new QueryRule("ontologyTermSynonym", QueryRule.Operator.SEARCH, term));
            queryRules.add(new QueryRule(QueryRule.Operator.OR));
        }
        if (queryRules.size() > 0) {
            queryRules.remove(queryRules.size() - 1);
        }
        SearchRequest request = new SearchRequest(documentType, queryRules, null);
        Iterator iterator = this.searchService.search(request).getSearchHits().iterator();
        ArrayList<TermComparison> listOfHits = new ArrayList<TermComparison>();
        while (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            listOfHits.add(new TermComparison(hit));
        }
        Collections.sort(listOfHits);
        HashSet<String> positionFilter = new HashSet<String>();
        HashSet<String> addedCandidates = new HashSet<String>();
        HashMap<String, Map> mapUriTerm = new HashMap<String, Map>();
        uniqueTerms = this.stemMembers(new ArrayList<String>(uniqueTerms), stemmer);
        for (TermComparison termComparision : listOfHits) {
            Hit hit = termComparision.getHit();
            Map data = hit.getColumnValueMap();
            String ontologyTermSynonym = data.get("ontologyTermSynonym").toString().toLowerCase();
            String ontologyTerm = data.get("ontologyTerm").toString().toLowerCase();
            if (!ontologyTerm.equals(ontologyTermSynonym) && addedCandidates.contains(ontologyTermSynonym) || !this.validateOntologyTerm(uniqueTerms, ontologyTermSynonym, stemmer, positionFilter)) continue;
            mapUriTerm.put(data.get("ontologyTermIRI").toString(), data);
            addedCandidates.add(ontologyTermSynonym);
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        if (feature.getDefinitions_Identifier() != null) {
            identifiers.addAll(feature.getDefinitions_Identifier());
        }
        for (String uri : mapUriTerm.keySet()) {
            if (identifiers.contains(uri)) continue;
            identifiers.add(uri);
        }
        feature.setDefinitions_Identifier(identifiers);
        if (mapUriTerm.size() > 0) {
            for (OntologyTerm ot : db.find(OntologyTerm.class, new QueryRule[]{new QueryRule("termAccession", QueryRule.Operator.IN, new ArrayList(mapUriTerm.keySet()))})) {
                mapUriTerm.remove(ot.getTermAccession());
            }
        }
        ArrayList<OntologyTerm> listOfOntologyTerms = new ArrayList<OntologyTerm>();
        HashMap<String, String> ontologyInfo = new HashMap<String, String>();
        for (Map.Entry entry : mapUriTerm.entrySet()) {
            String uri = (String)entry.getKey();
            Map data = (Map)entry.getValue();
            String ontologyUri = data.get("ontologyIRI").toString();
            String ontologyName = data.get("ontologyName").toString();
            ontologyInfo.put(ontologyUri, ontologyName);
            String ontologyLabel = data.get("ontologyLabel").toString();
            String term = ontologyLabel == null ? data.get("ontologyTerm").toString().toLowerCase() : ontologyLabel + ":" + data.get("ontologyTerm").toString().toLowerCase();
            OntologyTerm ot = new OntologyTerm();
            ot.setIdentifier(uri);
            ot.setTermAccession(uri);
            ot.setName(term);
            ot.setOntology_Identifier(ontologyUri);
            listOfOntologyTerms.add(ot);
        }
        if (listOfOntologyTerms.size() > 0) {
            this.addOntologies(ontologyInfo);
        }
        if (listOfOntologyTerms.size() > 0) {
            db.add(listOfOntologyTerms);
        }
        return identifiers;
    }

    private void addOntologies(Map<String, String> ontologyInfo) throws DatabaseException {
        ArrayList<String> ontologyUris = new ArrayList<String>();
        ArrayList<Ontology> listOfOntologies = new ArrayList<Ontology>();
        for (Ontology ontology : this.database.find(Ontology.class, new QueryRule[]{new QueryRule("ontologyURI", QueryRule.Operator.IN, new ArrayList<String>(ontologyInfo.keySet()))})) {
            ontologyUris.add(ontology.getOntologyURI());
        }
        for (Map.Entry entry : ontologyInfo.entrySet()) {
            String ontologyUri = (String)entry.getKey();
            String ontologyName = (String)entry.getValue();
            if (ontologyUris.contains(ontologyUri)) continue;
            Ontology ontology = new Ontology();
            ontology.setName(ontologyName);
            ontology.setIdentifier(ontologyUri);
            ontology.setOntologyURI(ontologyUri);
            listOfOntologies.add(ontology);
        }
        if (listOfOntologies.size() != 0) {
            this.database.add(listOfOntologies);
        }
    }

    private boolean validateOntologyTerm(Set<String> uniqueSets, String ontologyTermSynonym, PorterStemmer stemmer, Set<String> positionFilter) {
        Set<String> termsFromDescription = this.stemMembers(Arrays.asList(ontologyTermSynonym.split(" +")), stemmer);
        HashSet stemmedWords = new HashSet();
        for (String eachTerm : termsFromDescription) {
            if (uniqueSets.contains(eachTerm)) continue;
            return false;
        }
        for (String eachTerm : stemmedWords) {
            if (positionFilter.contains(eachTerm)) {
                return false;
            }
            positionFilter.add(eachTerm);
        }
        return true;
    }

    private Set<String> stemMembers(List<String> originalList, PorterStemmer stemmer) {
        HashSet<String> newList = new HashSet<String>();
        for (String eachTerm : originalList) {
            stemmer.setCurrent(eachTerm);
            stemmer.stem();
            eachTerm = stemmer.getCurrent();
            newList.add(eachTerm);
        }
        return newList;
    }

    public QueryRule[] toNestedQuery(List<QueryRule> rules) {
        QueryRule[] nestedQuery = new QueryRule[rules.size()];
        rules.toArray(nestedQuery);
        return nestedQuery;
    }

    @Override
    public float finishedPercentage() {
        return 0.0f;
    }

    class TermComparison
    implements Comparable<TermComparison> {
        private final Hit hit;
        private final Integer synonymLength;
        private final Integer termLength;

        public TermComparison(Hit hit) {
            Map data = hit.getColumnValueMap();
            String ontologyTermSynonym = data.get("ontologyTermSynonym").toString().toLowerCase();
            String ontologyTerm = data.get("ontologyTerm").toString().toLowerCase();
            this.hit = hit;
            this.synonymLength = ontologyTermSynonym.split(" +").length;
            this.termLength = ontologyTerm.split(" +").length;
        }

        private Integer getSynonymLength() {
            return this.synonymLength;
        }

        private Integer getTermLength() {
            return this.termLength;
        }

        public Hit getHit() {
            return this.hit;
        }

        @Override
        public int compareTo(TermComparison other) {
            if (this.synonymLength.compareTo(other.getSynonymLength()) == 0) {
                return this.termLength.compareTo(other.getTermLength());
            }
            return this.synonymLength.compareTo(other.getSynonymLength()) * -1;
        }
    }
}

