/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyindexer;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.omx.biobankconnect.ontologyindexer.OntologyIndexer;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.molgenis.omx.biobankconnect.utils.OntologyTable;
import org.molgenis.omx.biobankconnect.utils.OntologyTermTable;
import org.molgenis.search.SearchService;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;

public class AsyncOntologyIndexer
implements OntologyIndexer,
InitializingBean {
    @Autowired
    @Qualifier(value="unsecuredDatabase")
    private Database database;
    private SearchService searchService;
    private String ontologyUri = null;
    private boolean isCorrectOntology = true;
    private static final Logger logger = Logger.getLogger(AsyncOntologyIndexer.class);
    private final AtomicInteger runningIndexProcesses = new AtomicInteger();

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isIndexingRunning() {
        return this.runningIndexProcesses.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void index(String ontologyName, File ontologyFile) {
        this.isCorrectOntology = true;
        this.runningIndexProcesses.incrementAndGet();
        try {
            OntologyLoader model = new OntologyLoader(ontologyName, ontologyFile);
            this.ontologyUri = model.getOntologyIRI() == null ? "" : model.getOntologyIRI();
            this.searchService.indexTupleTable("ontology-" + this.ontologyUri, (TupleTable)new OntologyTable(model, this.database));
            this.searchService.indexTupleTable("ontologyTerm-" + this.ontologyUri, (TupleTable)new OntologyTermTable(model, this.database));
        }
        catch (OWLOntologyCreationException e) {
            this.isCorrectOntology = false;
            logger.error((Object)"Exception imported file is not a valid ontology", (Throwable)e);
        }
        finally {
            this.runningIndexProcesses.decrementAndGet();
            this.ontologyUri = null;
        }
    }

    @Override
    public void removeOntology(String ontologyURI) {
        this.searchService.deleteDocumentsByType("ontology-" + ontologyURI);
        this.searchService.deleteDocumentsByType("ontologyTerm-" + ontologyURI);
    }

    @Override
    public String getOntologyUri() {
        return this.ontologyUri;
    }

    @Override
    public boolean isCorrectOntology() {
        return this.isCorrectOntology;
    }
}

